/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.CleanUpHandler;
import adams.core.MessageCollection;
import adams.core.classmanager.ClassManager;
import adams.gui.core.ButtonTabComponent;
import adams.gui.core.DragAndDropTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JPopupMenu;

public class InvestigatorTabbedPane
extends DragAndDropTabbedPane
implements CleanUpHandler {
    private static final long serialVersionUID = -8555377473460866456L;
    protected InvestigatorPanel m_Owner;

    public InvestigatorTabbedPane(InvestigatorPanel owner) {
        this.m_Owner = owner;
        this.setCloseTabsWithMiddleMouseButton(false);
        this.setShowCloseTabButton(true);
    }

    public InvestigatorPanel getOwner() {
        return this.m_Owner;
    }

    public void addTab(AbstractInvestigatorTab tab) {
        this.addTab(tab, false);
    }

    public void addTab(final AbstractInvestigatorTab tab, boolean show) {
        tab.setOwner(this.getOwner());
        tab.setFrameTitle(tab.getTitle());
        this.addTab(tab.getTitle(), (Component)((Object)tab));
        final ButtonTabComponent button = (ButtonTabComponent)this.getTabComponentAt(this.getTabCount() - 1);
        button.setIcon(tab.getTabIcon() == null ? null : GUIHelper.getIcon((String)tab.getTabIcon()));
        button.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick((MouseEvent)e)) {
                    JPopupMenu menu = tab.createPopupMenu();
                    menu.show((Component)button, e.getX(), e.getY());
                    e.consume();
                } else if (MouseUtils.isLeftClick((MouseEvent)e)) {
                    InvestigatorTabbedPane.this.setSelectedComponent((Component)((Object)tab));
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        if (show) {
            this.setSelectedIndex(this.getTabCount() - 1);
        }
    }

    public void copySelectedTab() {
        this.copyTabAt(this.getSelectedIndex());
    }

    public void copyTabAt(int index) {
        if (index == -1) {
            return;
        }
        AbstractInvestigatorTab tab = (AbstractInvestigatorTab)((Object)this.getComponentAt(index));
        MessageCollection errors = new MessageCollection();
        try {
            AbstractInvestigatorTab tabNew = (AbstractInvestigatorTab)tab.getClass().newInstance();
            this.addTab(tabNew);
            tabNew.deserialize(ClassManager.getSingleton().deepCopy(tab.serialize(new HashSet<AbstractInvestigatorTab.SerializationOption>(Arrays.asList(AbstractInvestigatorTab.SerializationOption.values())))), errors);
        }
        catch (Exception ex) {
            errors.add("Failed to copy tab!", (Throwable)ex);
        }
        if (!errors.isEmpty()) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Errors occurred when copying tab:\n" + errors));
        }
    }

    public void cleanUp() {
        this.removeAll();
    }
}

