/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.finalmodel;

import adams.core.ObjectCopyHelper;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.finalmodel.AbstractFinalModelGenerator;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Vote;
import weka.core.Instances;

public class VotedFolds
extends AbstractFinalModelGenerator {
    private static final long serialVersionUID = 3061850581812117899L;
    protected Vote m_Template;

    public String globalInfo() {
        return "Generates a Vote meta-classifier from the models from the cross-validation folds.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("template", "template", (Object)new Vote());
    }

    public void setTemplate(Vote value) {
        this.m_Template = value;
        this.reset();
    }

    public Vote getTemplate() {
        return this.m_Template;
    }

    public String voteTipText() {
        return "The template of the Vote classifier to use.";
    }

    @Override
    public void generate(AbstractClassifierEvaluation eval, Instances data, ResultItem item) {
        if (!item.hasFoldModels()) {
            ((ClassifyTab)eval.getOwner()).logMessage(((Object)((Object)this)).getClass().getName() + ": cannot generate Vote model as no fold models available!");
            return;
        }
        try {
            Vote cls = (Vote)ObjectCopyHelper.copyObject((Object)this.m_Template);
            cls.setClassifiers(item.getFoldModels());
            item.setModel((Classifier)cls);
            if (item.hasRunInformation()) {
                eval.addObjectSize(item.getRunInformation(), "Final model size", cls);
            }
        }
        catch (Exception e) {
            ((ClassifyTab)eval.getOwner()).logError("Failed to build final model!", e, "Final model build");
        }
    }
}

