/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.MultiPagePane;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.wekainvestigator.output.TableContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.PredictionHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import com.github.fracpete.javautils.Enumerate;
import com.github.fracpete.javautils.enumerate.Enumerated;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;

public class Predictions
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected boolean m_AddLabelIndex;
    protected boolean m_ShowError;
    protected boolean m_ShowProbability;
    protected boolean m_ShowDistribution;
    protected boolean m_ShowWeight;

    public String globalInfo() {
        return "Generates classifier errors plot.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-index", "addLabelIndex", (Object)false);
        this.m_OptionManager.add("error", "showError", (Object)false);
        this.m_OptionManager.add("probability", "showProbability", (Object)false);
        this.m_OptionManager.add("distribution", "showDistribution", (Object)false);
        this.m_OptionManager.add("weight", "showWeight", (Object)false);
    }

    public void setAddLabelIndex(boolean value) {
        this.m_AddLabelIndex = value;
        this.reset();
    }

    public boolean getAddLabelIndex() {
        return this.m_AddLabelIndex;
    }

    public String addLabelIndexTipText() {
        return "If set to true, then the label is prefixed with the index.";
    }

    public void setShowError(boolean value) {
        this.m_ShowError = value;
        this.reset();
    }

    public boolean getShowError() {
        return this.m_ShowError;
    }

    public String showErrorTipText() {
        return "If set to true, then the error will be displayed as well.";
    }

    public void setShowProbability(boolean value) {
        this.m_ShowProbability = value;
        this.reset();
    }

    public boolean getShowProbability() {
        return this.m_ShowProbability;
    }

    public String showProbabilityTipText() {
        return "If set to true, then the probability of the prediction will be displayed as well (only for nominal class attributes).";
    }

    public void setShowDistribution(boolean value) {
        this.m_ShowDistribution = value;
        this.reset();
    }

    public boolean getShowDistribution() {
        return this.m_ShowDistribution;
    }

    public String showDistributionTipText() {
        return "If set to true, then the class distribution will be displayed as well (only for nominal class attributes).";
    }

    public void setShowWeight(boolean value) {
        this.m_ShowWeight = value;
        this.reset();
    }

    public boolean getShowWeight() {
        return this.m_ShowWeight;
    }

    public String showWeightTipText() {
        return "If set to true, then the instance weight will be displayed as well.";
    }

    @Override
    public String getTitle() {
        return "Predictions";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null;
    }

    protected TableContentPanel createOutput(Evaluation eval, int[] originalIndices, SpreadSheet additionalAttributes, MessageCollection errors) {
        SpreadSheet sheet = PredictionHelper.toSpreadSheet((LoggingSupporter)this, errors, eval, originalIndices, additionalAttributes, this.m_AddLabelIndex, this.m_ShowDistribution, this.m_ShowProbability, this.m_ShowError, this.m_ShowWeight);
        if (sheet == null) {
            if (errors.isEmpty()) {
                errors.add("Failed to generate prediction!");
            }
            return null;
        }
        SpreadSheetTable table = new SpreadSheetTable(sheet);
        return new TableContentPanel((SortableAndSearchableTable)table, true, true);
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (item.hasFoldEvaluations()) {
            MultiPagePane multiPage = this.newMultiPagePane(item);
            this.addPage(multiPage, "Full", (JComponent)((Object)this.createOutput(item.getEvaluation(), item.getOriginalIndices(), item.getAdditionalAttributes(), errors)), 0);
            for (Enumerated eval : Enumerate.enumerate((Object[])item.getFoldEvaluations())) {
                this.addPage(multiPage, "Fold " + (eval.index + 1), (JComponent)((Object)this.createOutput(item.getFoldEvaluations()[eval.index], null, null, errors)), eval.index + 1);
            }
            if (multiPage.getPageCount() > 0) {
                multiPage.setSelectedIndex(0);
            }
            return multiPage;
        }
        return this.createOutput(item.getEvaluation(), item.getOriginalIndices(), item.getAdditionalAttributes(), errors);
    }
}

