/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import weka.classifiers.Sourcable;

public class SourceCode
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected String m_Classname;

    public String globalInfo() {
        return "Outputs source code from the model (if the classifier implements " + Sourcable.class.getName() + ").";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classname", "classname", (Object)"MyModel");
    }

    public void setClassname(String value) {
        this.m_Classname = value;
        this.reset();
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String classnameTipText() {
        return "The classname to use in the generated code.";
    }

    @Override
    public String getTitle() {
        return "Source code";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasModel() && item.getModel() instanceof Sourcable;
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasModel()) {
            errors.add("No model available!");
            return null;
        }
        if (!(item.getModel() instanceof Sourcable)) {
            errors.add("Classifier does not implement " + Sourcable.class.getName() + "!");
            return null;
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        try {
            text.setText(((Sourcable)item.getModel()).toSource(this.m_Classname));
        }
        catch (Exception e) {
            errors.add("Failed to generate source code!", (Throwable)e);
            return null;
        }
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

