/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ClassesToClusters
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = -4460266467650893551L;
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxTrain;
    protected BaseComboBox<String> m_ComboBoxTest;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected BaseComboBox<String> m_ComboBoxClass;
    protected DefaultComboBoxModel<String> m_ModelClass;

    public String globalInfo() {
        return "Performs a classes-to-clusters mapping, after the clusterer got trained on the selected training set and evaluated against the specified test set.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxTrain = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxTrain.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Train", this.m_ComboBoxTrain);
        this.m_ComboBoxTest = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxTest.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Test", this.m_ComboBoxTest);
        this.m_ComboBoxClass = new BaseComboBox();
        this.m_ComboBoxClass.addActionListener(e -> ((ClusterTab)this.getOwner()).updateButtons());
        this.m_PanelParameters.addParameter("Class", this.m_ComboBoxClass);
    }

    @Override
    public String getName() {
        return "Classes to clusters";
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        Instances test;
        Capabilities caps;
        if (!this.isValidDataIndex(this.m_ComboBoxTrain)) {
            return "No training data available!";
        }
        if (!this.isValidDataIndex(this.m_ComboBoxTest)) {
            return "No test data available!";
        }
        if (this.m_ComboBoxClass.getSelectedIndex() < 1) {
            return "No class attribute set!";
        }
        Instances train = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        if (train.classIndex() == -1) {
            caps = clusterer.getCapabilities();
            try {
                if (!caps.test(train)) {
                    if (caps.getFailReason() != null) {
                        return caps.getFailReason().getMessage();
                    }
                    return "Clusterer cannot handle training data!";
                }
            }
            catch (Exception e) {
                return "Clusterer cannot handle data: " + e;
            }
        }
        if ((test = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex()).getData()).classIndex() == -1) {
            caps = clusterer.getCapabilities();
            try {
                if (!caps.test(test)) {
                    if (caps.getFailReason() != null) {
                        return caps.getFailReason().getMessage();
                    }
                    return "Clusterer cannot handle test data!";
                }
            }
            catch (Exception e) {
                return "Clusterer cannot handle data: " + e;
            }
        }
        if (!train.equalHeaders(test)) {
            return train.equalHeadersMsg(test);
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    protected int numClasses() {
        int result = -1;
        String classAtt = "" + (String)this.m_ComboBoxClass.getSelectedItem();
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex()).getData();
        Attribute att = data.attribute(classAtt);
        if (att != null) {
            result = att.numValues();
        }
        return result;
    }

    protected int classIndex(Instances data) {
        Attribute att;
        String classAtt = "" + (String)this.m_ComboBoxClass.getSelectedItem();
        if ((data = new Instances(data)).classIndex() > -1) {
            data.setClassIndex(-1);
        }
        if ((att = data.attribute(classAtt)) != null) {
            return att.index();
        }
        return -1;
    }

    protected Instances removeClassAttribute(Instances data) {
        int classIndex = this.classIndex(data);
        if ((data = new Instances(data)).classIndex() > -1) {
            data.setClassIndex(-1);
        }
        if (classIndex > -1) {
            data.deleteAttributeAt(classIndex);
        }
        return data;
    }

    protected String toMatrixString(int numClusters, int[][] counts, int[] clusterTotals, Instances inst) throws Exception {
        int i;
        StringBuilder result = new StringBuilder("Classes to clusters\n==================\n\n");
        int maxval = 0;
        for (int i2 = 0; i2 < numClusters; ++i2) {
            for (int j = 0; j < counts[i2].length; ++j) {
                if (counts[i2][j] <= maxval) continue;
                maxval = counts[i2][j];
            }
        }
        int Cwidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0)), (int)(Math.log(numClusters) / Math.log(10.0)));
        result.append("\n");
        for (i = 0; i < numClusters; ++i) {
            if (clusterTotals[i] <= 0) continue;
            result.append(" ").append(Utils.doubleToString((double)i, (int)Cwidth, (int)0));
        }
        result.append("  <-- assigned to cluster\n");
        for (i = 0; i < counts[0].length; ++i) {
            for (int j = 0; j < numClusters; ++j) {
                if (clusterTotals[j] <= 0) continue;
                result.append(" ").append(Utils.doubleToString((double)counts[j][i], (int)Cwidth, (int)0));
            }
            result.append(" | ").append(inst.classAttribute().value(i)).append("\n");
        }
        return result.toString();
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        String msg = this.canEvaluate(clusterer);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer dataCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex());
        Instances data = dataCont.getData();
        Instances train = this.removeClassAttribute(data);
        Clusterer model = (Clusterer)OptionUtils.shallowCopy((Object)clusterer);
        ((ClusterTab)this.getOwner()).logMessage("Building clusterer on '" + data.relationName() + "' without class attribute using " + OptionUtils.getCommandLine((Object)clusterer));
        model.buildClusterer(train);
        data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex()).getData();
        Instances test = this.removeClassAttribute(data);
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances (train)", (Object)train.numInstances());
        runInfo.add("# Instances (test)", (Object)test.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        ((ClusterTab)this.getOwner()).logMessage("Testing clusterer on '" + data.relationName() + "' without class attribute using " + OptionUtils.getCommandLine((Object)clusterer));
        ClusterEvaluation eval = new ClusterEvaluation();
        eval.setClusterer(model);
        eval.evaluateClusterer(test);
        ((ClusterTab)this.getOwner()).logMessage("Determining classes to clusters mapping on '" + data.relationName() + "' for " + OptionUtils.getCommandLine((Object)clusterer));
        int numClusters = model.numberOfClusters();
        int[][] counts = new int[numClusters][this.numClasses()];
        int[] clusterTotals = new int[numClusters];
        double[] best = new double[numClusters + 1];
        double[] current = new double[numClusters + 1];
        double[] m_clusterAssignments = eval.getClusterAssignments();
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance instance = data.instance(i);
            if (!(m_clusterAssignments[i] >= 0.0)) continue;
            int[] nArray = counts[(int)m_clusterAssignments[i]];
            int n = (int)instance.value(this.classIndex(data));
            nArray[n] = nArray[n] + 1;
            int n2 = (int)m_clusterAssignments[i];
            clusterTotals[n2] = clusterTotals[n2] + 1;
        }
        best[numClusters] = Double.MAX_VALUE;
        ClusterEvaluation.mapClasses((int)numClusters, (int)0, (int[][])counts, (int[])clusterTotals, (double[])current, (double[])best, (int)0);
        String matrix = this.toMatrixString(numClusters, counts, clusterTotals, new Instances(data, 0));
        item.update(eval, "Classes to clusters", (Serializable)((Object)matrix), model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        int indexTrain = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxTrain.getSelectedItem());
        int indexTest = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxTest.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxTrain.setModel(this.m_ModelDatasets);
            if (indexTrain == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTrain.setSelectedIndex(0);
            } else if (indexTrain > -1) {
                this.m_ComboBoxTrain.setSelectedIndex(indexTrain);
            }
            this.m_ComboBoxTest.setModel(this.m_ModelDatasets);
            if (indexTest == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTest.setSelectedIndex(0);
            } else if (indexTest > -1) {
                this.m_ComboBoxTest.setSelectedIndex(indexTest);
            }
        }
        this.m_ModelClass = new DefaultComboBoxModel();
        this.m_ModelClass.addElement("");
        if (this.m_ComboBoxTest.getSelectedIndex() != -1) {
            DataContainer cont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex());
            Instances data = cont.getData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                this.m_ModelClass.addElement(data.attribute(i).name());
            }
        }
        this.m_ComboBoxClass.setModel(this.m_ModelClass);
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxTrain.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
    }
}

