/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab;

import adams.gui.core.BaseComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.Utils;

public class AttributeSummaryPanel
extends JPanel {
    static final long serialVersionUID = -5434987925737735880L;
    protected static final String NO_SOURCE = "None";
    protected JLabel m_AttributeNameLab = new JLabel("None");
    protected JLabel m_AttributeTypeLab = new JLabel("None");
    protected JLabel m_MissingLab = new JLabel("None");
    protected JLabel m_UniqueLab = new JLabel("None");
    protected JLabel m_DistinctLab = new JLabel("None");
    protected JTable m_StatsTable = new JTable(){
        private static final long serialVersionUID = 7165142874670048578L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    protected Instances m_Instances;
    protected AttributeStats[] m_AttributeStats;
    protected boolean m_allEqualWeights = true;

    public AttributeSummaryPanel() {
        JPanel simple = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        simple.setLayout(gbL);
        JLabel lab = new JLabel("Name:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.gridwidth = 3;
        gbL.setConstraints(this.m_AttributeNameLab, gbC);
        simple.add(this.m_AttributeNameLab);
        this.m_AttributeNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        lab = new JLabel("Type:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 4;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 5;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_AttributeTypeLab, gbC);
        simple.add(this.m_AttributeTypeLab);
        this.m_AttributeTypeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        lab = new JLabel("Missing:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_MissingLab, gbC);
        simple.add(this.m_MissingLab);
        this.m_MissingLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        lab = new JLabel("Distinct:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 2;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 3;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_DistinctLab, gbC);
        simple.add(this.m_DistinctLab);
        this.m_DistinctLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        lab = new JLabel("Unique:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 4;
        gbL.setConstraints(lab, gbC);
        simple.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 5;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_UniqueLab, gbC);
        simple.add(this.m_UniqueLab);
        this.m_UniqueLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)simple, "North");
        this.add((Component)new JScrollPane(this.m_StatsTable), "Center");
        this.m_StatsTable.getSelectionModel().setSelectionMode(0);
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_AttributeStats = new AttributeStats[inst != null ? inst.numAttributes() : 0];
        this.m_AttributeNameLab.setText(NO_SOURCE);
        this.m_AttributeTypeLab.setText(NO_SOURCE);
        this.m_MissingLab.setText(NO_SOURCE);
        this.m_UniqueLab.setText(NO_SOURCE);
        this.m_DistinctLab.setText(NO_SOURCE);
        this.m_StatsTable.setModel(new DefaultTableModel());
        if (this.m_Instances == null) {
            return;
        }
        this.m_allEqualWeights = true;
        if (this.m_Instances.numInstances() == 0) {
            return;
        }
        double w = this.m_Instances.instance(0).weight();
        for (int i = 1; i < this.m_Instances.numInstances(); ++i) {
            if (this.m_Instances.instance(i).weight() == w) continue;
            this.m_allEqualWeights = false;
            break;
        }
    }

    public void setAttribute(final int index) {
        this.setHeader(index);
        if (this.m_AttributeStats[index] == null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    AttributeSummaryPanel.this.m_AttributeStats[index] = AttributeSummaryPanel.this.m_Instances.attributeStats(index);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AttributeSummaryPanel.this.setDerived(index);
                            AttributeSummaryPanel.this.m_StatsTable.sizeColumnsToFit(-1);
                            AttributeSummaryPanel.this.m_StatsTable.revalidate();
                            AttributeSummaryPanel.this.m_StatsTable.repaint();
                        }
                    });
                }
            };
            t.setPriority(1);
            t.start();
        } else {
            this.setDerived(index);
        }
    }

    protected void setDerived(int index) {
        AttributeStats as = this.m_AttributeStats[index];
        long percent = Math.round(100.0 * (double)as.missingCount / (double)as.totalCount);
        this.m_MissingLab.setText("" + as.missingCount + " (" + percent + "%)");
        percent = Math.round(100.0 * (double)as.uniqueCount / (double)as.totalCount);
        this.m_UniqueLab.setText("" + as.uniqueCount + " (" + percent + "%)");
        this.m_DistinctLab.setText("" + as.distinctCount);
        this.setTable(as, index);
    }

    protected void setTable(AttributeStats as, int index) {
        if (as.nominalCounts != null) {
            Attribute att = this.m_Instances.attribute(index);
            Object[] colNames = new Object[]{"No.", "Label", "Count", "Weight"};
            Object[][] data = new Object[as.nominalCounts.length][4];
            for (int i = 0; i < as.nominalCounts.length; ++i) {
                data[i][0] = i + 1;
                data[i][1] = att.value(i);
                data[i][2] = as.nominalCounts[i];
                data[i][3] = Utils.doubleToString((double)as.nominalWeights[i], (int)3);
            }
            this.m_StatsTable.setModel(new DefaultTableModel(data, colNames));
            this.m_StatsTable.getColumnModel().getColumn(0).setMaxWidth(60);
            DefaultTableCellRenderer tempR = new DefaultTableCellRenderer();
            tempR.setHorizontalAlignment(4);
            this.m_StatsTable.getColumnModel().getColumn(0).setCellRenderer(tempR);
        } else if (as.numericStats != null) {
            Object[] colNames = new Object[]{"Statistic", "Value"};
            Object[][] data = new Object[4][2];
            data[0][0] = "Minimum";
            data[1][0] = "Maximum";
            data[2][0] = "Mean" + (!this.m_allEqualWeights ? " (weighted)" : "");
            data[3][0] = "StdDev" + (!this.m_allEqualWeights ? " (weighted)" : "");
            if (this.m_Instances.attribute(index).isDate()) {
                data[0][1] = this.m_Instances.attribute(index).formatDate(as.numericStats.min);
                data[1][1] = this.m_Instances.attribute(index).formatDate(as.numericStats.max);
                data[2][1] = this.m_Instances.attribute(index).formatDate(as.numericStats.mean);
                data[3][1] = this.m_Instances.attribute(index).formatDate(as.numericStats.stdDev);
            } else {
                data[0][1] = Utils.doubleToString((double)as.numericStats.min, (int)3);
                data[1][1] = Utils.doubleToString((double)as.numericStats.max, (int)3);
                data[2][1] = Utils.doubleToString((double)as.numericStats.mean, (int)3);
                data[3][1] = Utils.doubleToString((double)as.numericStats.stdDev, (int)3);
            }
            this.m_StatsTable.setModel(new DefaultTableModel(data, colNames));
        } else {
            this.m_StatsTable.setModel(new DefaultTableModel());
        }
        this.m_StatsTable.getColumnModel().setColumnMargin(4);
    }

    protected void setHeader(int index) {
        if (this.m_Instances == null) {
            return;
        }
        Attribute att = this.m_Instances.attribute(index);
        this.m_AttributeNameLab.setText(att.name());
        switch (att.type()) {
            case 1: {
                this.m_AttributeTypeLab.setText("Nominal");
                break;
            }
            case 0: {
                this.m_AttributeTypeLab.setText("Numeric");
                break;
            }
            case 2: {
                this.m_AttributeTypeLab.setText("String");
                break;
            }
            case 3: {
                this.m_AttributeTypeLab.setText("Date");
                break;
            }
            case 4: {
                this.m_AttributeTypeLab.setText("Relational");
                break;
            }
            default: {
                this.m_AttributeTypeLab.setText("Unknown");
            }
        }
        this.m_MissingLab.setText("...");
        this.m_UniqueLab.setText("...");
        this.m_DistinctLab.setText("...");
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Attribute Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            final weka.gui.AttributeSummaryPanel p = new weka.gui.AttributeSummaryPanel();
            p.setBorder((Border)BorderFactory.createTitledBorder("Attribute"));
            jf.getContentPane().add((Component)p, "Center");
            final BaseComboBox j = new BaseComboBox();
            j.setEnabled(false);
            j.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    p.setAttribute(j.getSelectedIndex());
                }
            });
            jf.getContentPane().add((Component)j, "North");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances inst = new Instances((Reader)r);
                p.setInstances(inst);
                p.setAttribute(0);
                String[] names = new String[inst.numAttributes()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = inst.attribute(i).name();
                }
                j.setModel(new DefaultComboBoxModel<String>(names));
                j.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

