/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction;

import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeRange;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AnyToString;

public class ConvertToString
extends AbstractSelectedAttributesAction {
    private static final long serialVersionUID = -217537095007987947L;

    public ConvertToString() {
        this.setName("Convert to string");
        this.setIcon("to_string.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        if (this.getSelectedRows().length != 1) {
            return;
        }
        int index = this.getSelectedRows()[0];
        DataContainer cont = this.getData().get(index);
        int[] indices = this.getOwner().getAttributeSelectionPanel().getSelectedAttributes();
        if (indices.length == 0) {
            return;
        }
        StringBuilder indicesStr = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                indicesStr.append(",");
            }
            indicesStr.append("" + (indices[i] + 1));
        }
        Runnable run = () -> {
            this.showStatus("Converting checked attributes to string...");
            boolean keep = this.getOwner().getCheckBoxKeepName().isSelected();
            String oldName = cont.getData().relationName();
            AnyToString anytostring = new AnyToString();
            anytostring.setRange(new WekaAttributeRange(indicesStr.toString()));
            this.logMessage("Filter: " + OptionUtils.getCommandLine((Object)((Object)anytostring)));
            try {
                anytostring.setInputFormat(cont.getData());
                Instances filtered = Filter.useFilter((Instances)cont.getData(), (Filter)anytostring);
                if (keep) {
                    filtered.setRelationName(oldName);
                }
                cont.setData(filtered);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getSelectedRows()[0]));
                SwingUtilities.invokeLater(() -> {
                    if (this.getOwner().getAttributeSelectionPanel().getTable().getRowCount() > 0) {
                        this.getOwner().getAttributeSelectionPanel().getTable().setSelectedRow(0);
                    }
                });
                this.showStatus("Finished converting selected attributes to string...");
            }
            catch (Throwable ex) {
                this.logError("Failed to convert selected attributes to string!", ex, this.getName());
            }
            this.m_Owner.executionFinished();
            this.showStatus("");
        };
        this.m_Owner.submitJob(run);
    }

    @Override
    public void update() {
        this.setEnabled(this.getOwner() != null && !this.isBusy() && this.getSelectedRows().length == 1 && this.getOwner().getAttributeSelectionPanel().getSelectedAttributes().length > 0 && this.m_Owner.canStartExecution());
    }
}

