/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.runner;

import adams.core.DateUtils;
import adams.core.StatusMessageHandler;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractExperimentRunner;
import java.util.Date;
import weka.core.Instances;

public abstract class AbstractAdamsExperimentRunner<T extends AbstractExperiment>
extends AbstractExperimentRunner<T> {
    private static final long serialVersionUID = -5591889874714150118L;

    public AbstractAdamsExperimentRunner(ExperimenterPanel owner) throws Exception {
        super(owner);
    }

    @Override
    protected void doInitialize() throws Exception {
        ((AbstractExperiment)this.m_Exp).setStatusMessageHandler((StatusMessageHandler)this.m_Owner);
    }

    protected void loadResults() {
        this.logMessage("Attempting to load results...");
        Instances data = ((AbstractExperiment)this.m_Exp).toInstances();
        if (data != null) {
            this.m_Owner.getAnalysisPanel().setResults(data);
            this.logMessage("Successfully loaded results!");
        }
    }

    @Override
    protected void doRun() throws Exception {
        String result = ((AbstractExperiment)this.m_Exp).execute();
        if (result != null) {
            throw new Exception(result);
        }
    }

    @Override
    protected void postRun(boolean success) {
        if (success) {
            this.loadResults();
        }
        this.m_Owner.finishExecution();
        this.update();
        this.m_Running = false;
        this.logMessage("Done!");
        this.logMessage("--> END: " + DateUtils.getTimestampFormatter().format(new Date()));
        ((AbstractExperiment)this.m_Exp).setStatusMessageHandler(null);
    }

    @Override
    public void abortExperiment() {
        super.abortExperiment();
        ((AbstractExperiment)this.m_Exp).stopExecution();
    }
}

