/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.runner;

import adams.core.DateUtils;
import adams.core.ObjectCopyHelper;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.experiment.ExperimentWithCustomizableRelationNames;
import adams.gui.tools.wekamultiexperimenter.experiment.ResettableExperiment;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractExperimentRunner<T>
extends Thread
implements Serializable {
    private static final long serialVersionUID = -5591889874714150118L;
    protected static final String NOT_RUNNING = "Not running";
    protected ExperimenterPanel m_Owner;
    protected T m_Exp;
    protected boolean m_Running;
    protected boolean m_Aborted;

    public AbstractExperimentRunner(ExperimenterPanel owner) throws Exception {
        this.m_Owner = owner;
        Object exp = this.m_Owner.getExperiment();
        this.logMessage("--> START: " + DateUtils.getTimestampFormatter().format(new Date()));
        this.logMessage("Running experiment: " + exp.getClass().getName());
        this.m_Exp = ObjectCopyHelper.copyObject((Object)exp);
        if (this.m_Exp == null) {
            throw new IllegalStateException("Failed to create copy of experiment!");
        }
        this.logMessage("Made experiment copy");
    }

    public void abortExperiment() {
        this.m_Running = false;
        this.m_Aborted = true;
        this.logMessage("Aborting experiment!");
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public void logMessage(Throwable t) {
        this.m_Owner.logMessage(t);
    }

    public void logMessage(String msg) {
        this.m_Owner.logMessage(msg);
    }

    public void logError(Throwable t, String title) {
        this.m_Owner.logError(t, title);
    }

    public void logError(String msg, String title) {
        this.m_Owner.logError(msg, title);
    }

    public void showStatus(String msg) {
        this.m_Owner.logMessage(msg);
    }

    public void update() {
        this.m_Owner.update();
    }

    protected void preRun() throws Exception {
        if (this.m_Exp instanceof ExperimentWithCustomizableRelationNames) {
            ((ExperimentWithCustomizableRelationNames)this.m_Exp).setUseFilename(this.m_Owner.getUseFilename());
            ((ExperimentWithCustomizableRelationNames)this.m_Exp).setPrefixDatasetsWithIndex(this.m_Owner.getPrefixDatasetsWithIndex());
        }
        if (this.m_Exp instanceof ResettableExperiment) {
            ((ResettableExperiment)this.m_Exp).setResetResults(this.m_Owner.getResetResults());
        }
    }

    protected abstract void doInitialize() throws Exception;

    protected abstract void doRun() throws Exception;

    protected void postRun(boolean success) {
    }

    @Override
    public void run() {
        this.m_Running = true;
        this.m_Aborted = false;
        this.update();
        try {
            this.logMessage("Started");
            this.preRun();
            this.showStatus("Initializing...");
            this.doInitialize();
            this.showStatus("Running...");
            this.doRun();
            this.showStatus("Finished!");
            this.postRun(!this.m_Aborted && this.m_Running);
            this.m_Running = false;
        }
        catch (Exception ex) {
            try {
                this.logError(ex, "Execution error");
                this.showStatus(ex.getMessage());
                this.m_Running = false;
                this.postRun(!this.m_Aborted && this.m_Running);
                this.m_Running = false;
            }
            catch (Throwable throwable) {
                this.postRun(!this.m_Aborted && this.m_Running);
                this.m_Running = false;
                throw throwable;
            }
        }
    }
}

