/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.runner;

import adams.core.DateUtils;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractWekaExperimentRunner;
import java.io.File;
import java.util.Date;
import weka.experiment.Experiment;

public class DefaultWekaExperimentRunner
extends AbstractWekaExperimentRunner<Experiment> {
    private static final long serialVersionUID = -5499408120296699079L;

    public DefaultWekaExperimentRunner(ExperimenterPanel owner) throws Exception {
        super(owner);
    }

    @Override
    protected void doRun() throws Exception {
        int errors = 0;
        this.showStatus("Iterating...");
        while (this.m_Running && ((Experiment)this.m_Exp).hasMoreIterations()) {
            try {
                String current = "Iteration:";
                if (((Experiment)this.m_Exp).getUsePropertyIterator()) {
                    int cnum = ((Experiment)this.m_Exp).getCurrentPropertyNumber();
                    String ctype = ((Experiment)this.m_Exp).getPropertyArray().getClass().getComponentType().getName();
                    int lastDot = ctype.lastIndexOf(46);
                    if (lastDot != -1) {
                        ctype = ctype.substring(lastDot + 1);
                    }
                    String cname = " " + ctype + "=" + (cnum + 1) + ":" + ((Experiment)this.m_Exp).getPropertyArrayValue(cnum).getClass().getName();
                    current = current + cname;
                }
                String dname = ((File)((Experiment)this.m_Exp).getDatasets().elementAt(((Experiment)this.m_Exp).getCurrentDatasetNumber())).getName();
                current = current + " Dataset=" + dname + " Run=" + ((Experiment)this.m_Exp).getCurrentRunNumber();
                this.showStatus(current);
                ((Experiment)this.m_Exp).nextIteration();
            }
            catch (Exception ex) {
                ++errors;
                this.logMessage(ex);
                ex.printStackTrace();
                boolean continueAfterError = false;
                if (continueAfterError) {
                    ((Experiment)this.m_Exp).advanceCounters();
                    continue;
                }
                this.m_Running = false;
            }
        }
        this.showStatus("Postprocessing...");
        ((Experiment)this.m_Exp).postProcess();
        if (!this.m_Running) {
            this.logMessage("Interrupted");
        } else {
            this.logMessage("Finished");
        }
        if (errors == 1) {
            this.logMessage("There was " + errors + " error");
        } else {
            this.logMessage("There were " + errors + " errors");
        }
        this.showStatus("Not running");
    }

    @Override
    protected void postRun(boolean success) {
        super.postRun(success);
        this.m_Owner.finishExecution();
        this.update();
        this.m_Running = false;
        this.logMessage("Done!");
        this.logMessage("--> END: " + DateUtils.getTimestampFormatter().format(new Date()));
    }
}

