/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.NamedContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.ColorProviderWithNameSupport;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.instance.InstanceContainer;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class InstanceContainerManager
extends AbstractContainerManager<InstanceContainer>
implements VisibilityContainerManager<InstanceContainer>,
NamedContainerManager,
ColorContainerManager<InstanceContainer> {
    private static final long serialVersionUID = -4325235760470150191L;
    protected ContainerListManager<InstanceContainerManager> m_Owner;
    protected ColorProvider m_ColorProvider;

    public InstanceContainerManager(ContainerListManager<InstanceContainerManager> owner) {
        this.m_Owner = owner;
        this.m_ColorProvider = new DefaultColorProvider();
        if (owner instanceof DataChangeListener) {
            this.addDataChangeListener((DataChangeListener)owner);
        }
    }

    public ContainerListManager getOwner() {
        return this.m_Owner;
    }

    public synchronized void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        for (int i = 0; i < this.count(); ++i) {
            ((InstanceContainer)this.get(i)).setColor(this.getColor((InstanceContainer)this.get(i)));
        }
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public Color getColor(InstanceContainer cont) {
        if (this.m_ColorProvider instanceof ColorProviderWithNameSupport) {
            return ((ColorProviderWithNameSupport)this.m_ColorProvider).next(cont.getID());
        }
        return this.m_ColorProvider.next();
    }

    public void clear() {
        super.clear();
        this.m_ColorProvider.resetColors();
    }

    public InstanceContainer newContainer(Comparable o) {
        return new InstanceContainer(this, (Instance)((Object)o));
    }

    public void add(InstanceContainer c) {
        c.setColor(this.getColor(c));
        super.add((AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
    }

    public InstanceContainer set(int index, InstanceContainer c) {
        InstanceContainer result = (InstanceContainer)super.set(index, (AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public InstanceContainer remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        InstanceContainer result = (InstanceContainer)super.remove(index);
        this.m_ColorProvider.recycle(result.getColor());
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((InstanceContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int[] getVisibleIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public List<InstanceContainer> getAllVisible() {
        ArrayList<InstanceContainer> result = new ArrayList<InstanceContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            InstanceContainer cont = (InstanceContainer)((InstanceContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    public boolean isVisible(int index) {
        return ((InstanceContainer)this.get(index)).isVisible();
    }

    public void setVisible(int index, boolean visible) {
        ((InstanceContainer)this.get(index)).setVisible(visible);
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.VISIBILITY, index));
    }

    public InstanceContainer getVisible(int index) {
        InstanceContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (InstanceContainer)this.get(i);
            break;
        }
        return result;
    }

    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }

    protected boolean isMatch(InstanceContainer cont, String search, boolean regExp) {
        if (regExp) {
            return cont.getID().matches(search);
        }
        return cont.getID().toLowerCase().contains(search);
    }
}

