/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.gui.visualization.instance.AbstractInstancePanelUpdater;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstancePanel;

public class SimpleInstancePanelUpdater
extends AbstractInstancePanelUpdater {
    private static final long serialVersionUID = 4418135588639219439L;
    protected int m_UpdateInterval;
    protected int m_NumTokensAccepted;

    public String globalInfo() {
        return "Updates the flow after the specified number of tokens have been processed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-interval", "updateInterval", (Object)1, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_NumTokensAccepted = 0;
    }

    public void setUpdateInterval(int value) {
        if (value >= -1) {
            this.m_UpdateInterval = value;
            this.reset();
        } else {
            this.getLogger().severe("Update interval must be >= -1, provided: " + value);
        }
    }

    public int getUpdateInterval() {
        return this.m_UpdateInterval;
    }

    public String updateIntervalTipText() {
        return "Specifies the number of tokens after which the display is being updated (markers excluded); <= 0 means no update until flow finished.";
    }

    protected boolean canNotify(InstancePanel panel, InstanceContainer cont) {
        ++this.m_NumTokensAccepted;
        return this.m_UpdateInterval > 0 && this.m_NumTokensAccepted % this.m_UpdateInterval == 0;
    }
}

