/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance.plotpopup;

import adams.core.base.BaseRegExp;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.instance.InstanceUtils;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.container.DataContainerPanelWithContainerList;
import adams.gui.visualization.container.datacontainerpanel.plotpopup.AbstractPlotPopupCustomizer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Viewport
extends AbstractPlotPopupCustomizer<Instance, InstanceContainerManager, InstanceContainer> {
    private static final long serialVersionUID = 3295471324320509106L;

    public String getName() {
        return "Viewport";
    }

    public String getGroup() {
        return "graphics";
    }

    public boolean handles(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel) {
        return panel instanceof InstancePanel;
    }

    protected List<InstanceContainer> containersInViewport(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel) {
        ArrayList<InstanceContainer> result = new ArrayList<InstanceContainer>();
        AxisPanel axisX = panel.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = panel.getPlot().getAxis(Axis.LEFT);
        double minX = axisX.getActualMinimum();
        double maxX = axisX.getActualMaximum();
        double minY = axisY.getActualMinimum();
        double maxY = axisY.getActualMaximum();
        block0: for (InstanceContainer c : panel.getTableModelContainers(true)) {
            int to;
            int from;
            Instance sp = c.getData();
            List points = sp.toList();
            int[] indices = InstanceUtils.findEnclosingXs(points, (int)Math.floor(minX));
            int n = from = indices[1] == -1 ? indices[0] : indices[1];
            if (from == -1) {
                from = 0;
            }
            if ((to = (indices = InstanceUtils.findEnclosingXs(points, (int)Math.ceil(maxX)))[0]) == -1) {
                to = points.size() - 1;
            }
            for (int i = from; i <= to; ++i) {
                double amp = ((InstancePoint)((Object)points.get(i))).getY();
                if (!(amp >= minY) || !(amp <= maxY)) continue;
                result.add(c);
                continue block0;
            }
        }
        return result;
    }

    protected void display(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, List<InstanceContainer> conts) {
        Report report;
        String regexpStr = GUIHelper.showInputDialog(panel, (String)"Please enter regexp for fields to include (other than ID):", (String)"(Source)");
        if (regexpStr == null) {
            return;
        }
        BaseRegExp regexp = new BaseRegExp();
        if (!regexp.isValid(regexpStr)) {
            GUIHelper.showErrorMessage(panel, (String)("Invalid regular expression: " + regexpStr));
            return;
        }
        regexp.setValue(regexpStr);
        ArrayList<String> names = new ArrayList<String>();
        HashSet<AbstractField> fields = new HashSet<AbstractField>();
        for (InstanceContainer c : conts) {
            report = c.getData().getReport();
            for (AbstractField field : report.getFields()) {
                if (!regexp.isMatch(field.getName()) || fields.contains(field)) continue;
                fields.add(field);
                names.add(field.getName());
            }
        }
        Collections.sort(names);
        names.remove("ID");
        names.add(0, "ID");
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        for (String name : names) {
            row.addCell(name).setContentAsString(name);
        }
        for (InstanceContainer c : conts) {
            Instance sp = c.getData();
            report = sp.getReport();
            row = sheet.addRow();
            row.addCell("ID").setContentAsString(sp.getID());
            for (AbstractField field : fields) {
                if (!report.hasValue(field)) continue;
                row.addCell(field.getName()).setNative(report.getValue(field));
            }
        }
        SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(panel.getParentFrame(), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Instances in viewport");
        dialog.setSpreadSheet((SpreadSheet)sheet);
        dialog.pack();
        dialog.setLocationRelativeTo(panel);
        dialog.setVisible(true);
    }

    protected void chooseColor(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, List<InstanceContainer> conts) {
        Color newColor = JColorChooser.showDialog(panel, "Choose color", Color.BLUE);
        if (newColor == null) {
            return;
        }
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        manager.startUpdate();
        for (InstanceContainer cont : conts) {
            cont.setColor(newColor);
        }
        manager.finishUpdate();
    }

    protected void hide(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, List<InstanceContainer> conts) {
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        manager.startUpdate();
        for (InstanceContainer cont : conts) {
            cont.setVisible(false);
        }
        manager.finishUpdate();
    }

    protected void hideOthers(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, List<InstanceContainer> conts) {
        HashSet<InstanceContainer> keep = new HashSet<InstanceContainer>(conts);
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        manager.startUpdate();
        for (int i = 0; i < manager.count(); ++i) {
            if (keep.contains(manager.get(i))) continue;
            ((InstanceContainer)manager.get(i)).setVisible(false);
        }
        manager.finishUpdate();
    }

    public void customize(DataContainerPanelWithContainerList<Instance, InstanceContainerManager, InstanceContainer> panel, MouseEvent e, JPopupMenu menu) {
        List<InstanceContainer> conts = this.containersInViewport(panel);
        JMenu submenu = new JMenu("Viewport");
        menu.add(submenu);
        menu.setEnabled(conts.size() > 0);
        if (conts.size() > 0) {
            JMenuItem item = new JMenuItem("Display...");
            item.addActionListener(ae -> this.display(panel, conts));
            ((Container)submenu).add(item);
            item = new JMenuItem("Choose color...");
            item.addActionListener(ae -> this.chooseColor(panel, conts));
            ((Container)submenu).add(item);
            item = new JMenuItem("Hide");
            item.addActionListener(ae -> this.hide(panel, conts));
            ((Container)submenu).add(item);
            item = new JMenuItem("Hide others");
            item.addActionListener(ae -> this.hideOthers(panel, conts));
            ((Container)submenu).add(item);
        }
    }
}

