/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.gui.core.BaseComboBox;
import adams.gui.visualization.instances.InstancesTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import weka.core.Instances;

public class InstancesColumnComboBox
extends BaseComboBox {
    private static final long serialVersionUID = 5256160332596403161L;
    protected InstancesTable m_Table;

    public InstancesColumnComboBox(InstancesTable table) {
        this.m_Table = table;
        this.update();
        this.m_Table.getModel().addTableModelListener(e -> this.update());
        this.addActionListener(e -> {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            ColumnContainer cont = (ColumnContainer)this.getSelectedItem();
            int row = this.m_Table.getSelectedRow();
            if (row == -1) {
                row = 0;
            }
            int col = cont.getColumn();
            this.m_Table.showCell(row, ++col);
        });
    }

    protected synchronized void update() {
        ArrayList<ColumnContainer> columns = new ArrayList<ColumnContainer>();
        Instances data = this.m_Table.getInstances();
        if (data != null) {
            for (int i = 0; i < data.numAttributes(); ++i) {
                columns.add(new ColumnContainer(data.attribute(i).name(), i));
            }
            Collections.sort(columns);
        }
        this.setModel(new DefaultComboBoxModel<ColumnContainer>(columns.toArray(new ColumnContainer[0])));
    }

    public static class ColumnContainer
    implements Serializable,
    Comparable<ColumnContainer> {
        private static final long serialVersionUID = 8359213625873465324L;
        protected String m_Name;
        protected String m_NameLowerCase;
        protected int m_Column;

        public ColumnContainer(String name, int column) {
            this.m_Name = name;
            this.m_NameLowerCase = name.toLowerCase();
            this.m_Column = column;
        }

        public String getName() {
            return this.m_Name;
        }

        public String getNameLowerCase() {
            return this.m_NameLowerCase;
        }

        public int getColumn() {
            return this.m_Column;
        }

        @Override
        public int compareTo(ColumnContainer o) {
            if (o == null) {
                return 1;
            }
            int result = this.getNameLowerCase().compareTo(o.getNameLowerCase());
            if (result == 0) {
                result = Integer.compare(this.getColumn(), o.getColumn());
            }
            return result;
        }

        public String toString() {
            return this.m_Name + " [" + (this.m_Column + 1) + "]";
        }
    }
}

