/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.core.Utils;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.instances.instancestable.AbstractProcessSelectedRows;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.gui.visualization.instances.instancestable.ProcessRow;
import gnu.trove.set.hash.TDoubleHashSet;
import java.awt.Component;

public class ChangeInstanceWeights
extends AbstractProcessSelectedRows
implements ProcessRow {
    private static final long serialVersionUID = 8866236994813131751L;

    public String globalInfo() {
        return "Allows the user to change the weight of the selected instances.";
    }

    @Override
    public String getIconName() {
        return "weight.png";
    }

    @Override
    protected String getDefaultMenuItem() {
        return "Change instance weights...";
    }

    @Override
    public int minNumRows() {
        return 1;
    }

    @Override
    public int maxNumRows() {
        return -1;
    }

    @Override
    protected boolean doProcessSelectedRows(InstancesTablePopupMenuItemHelper.TableState state) {
        TDoubleHashSet weights = new TDoubleHashSet();
        for (int row : state.actRows) {
            weights.add(state.table.getInstances().instance(row).weight());
        }
        double weight = weights.size() == 1 ? weights.toArray()[0] : 1.0;
        String newWeightStr = GUIHelper.showInputDialog((Component)state.table.getParent(), (String)("Please enter new weight for selected row" + (state.selRows.length != 1 ? "s" : "") + ": "), (String)("" + weight));
        if (newWeightStr == null) {
            return false;
        }
        if (!Utils.isDouble((String)newWeightStr)) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Weight has to be a valid numnber, provided: " + newWeightStr));
            return false;
        }
        double newWeight = Utils.toDouble((String)newWeightStr);
        if (weight != newWeight) {
            state.table.addUndoPoint();
            for (int row : state.actRows) {
                state.table.getInstances().instance(row).setWeight(newWeight);
            }
        }
        return true;
    }

    @Override
    public boolean processRow(InstancesTablePopupMenuItemHelper.TableState state) {
        return this.processSelectedRows(state);
    }
}

