/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.Utils;
import adams.core.exception.NotImplementedException;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.event.SpreadSheetColumnInsertionEvent;
import adams.ml.data.DataCellView;
import adams.ml.data.InstancesView;
import java.util.ArrayList;
import java.util.Collection;
import weka.core.Instance;

public class InstanceView
implements DataRow {
    private static final long serialVersionUID = 1398119247909453155L;
    protected InstancesView m_Owner;
    protected Instance m_Data;

    public InstanceView(InstancesView owner, Instance data) {
        this.m_Owner = owner;
        this.m_Data = data;
    }

    public Instance getData() {
        return this.m_Data;
    }

    protected int cellKeyToIndex(String cellKey) {
        if (Utils.isInteger((String)cellKey)) {
            return Integer.parseInt(cellKey);
        }
        return -1;
    }

    public Cell addCell(String cellKey) {
        int col = this.cellKeyToIndex(cellKey);
        if (col > -1) {
            return new DataCellView(this, col);
        }
        throw new NotImplementedException();
    }

    public Cell removeCell(int columnIndex) {
        this.m_Data.setMissing(columnIndex);
        return null;
    }

    public Cell removeCell(String cellKey) {
        int col = this.cellKeyToIndex(cellKey);
        if (col > -1) {
            return this.removeCell(col);
        }
        return null;
    }

    public Cell getCell(String cellKey) {
        int col = this.cellKeyToIndex(cellKey);
        if (col > -1) {
            return this.getCell(col);
        }
        return null;
    }

    public Cell getCell(int columnIndex) {
        return new DataCellView(this, columnIndex);
    }

    public String getContent(int columnIndex) {
        Cell cell = this.getCell(columnIndex);
        if (cell != null) {
            return cell.getContent();
        }
        return null;
    }

    public String getCellKey(int columnIndex) {
        return "" + columnIndex;
    }

    public Collection<String> cellKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            result.add("" + i);
        }
        return result;
    }

    public Collection<Cell> cells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            result.add(this.getCell(i));
        }
        return result;
    }

    public int getCellCount() {
        return this.m_Data.numAttributes();
    }

    public boolean removeMissing() {
        return false;
    }

    public int indexOf(Cell cell) {
        if (cell instanceof DataCellView) {
            DataCellView view = (DataCellView)cell;
            if (view.getOwner().getData() == this.getData()) {
                return cell.index();
            }
            return -1;
        }
        return -1;
    }

    public void mergeWith(Row other) {
        throw new NotImplementedException();
    }

    public void setOwner(SpreadSheet owner) {
        if (!(owner instanceof InstancesView)) {
            throw new IllegalArgumentException("Owner can only be " + InstancesView.class.getName());
        }
        this.m_Owner = (InstancesView)owner;
    }

    public SpreadSheet getOwner() {
        return this.m_Owner;
    }

    public DataRow getClone(SpreadSheet owner) {
        if (owner instanceof InstancesView) {
            InstanceView result = new InstanceView((InstancesView)owner, this.m_Data);
            result.assign((Row)this);
            return result;
        }
        throw new IllegalArgumentException("Owner can only be " + InstancesView.class.getName());
    }

    public void clear() {
        for (int i = 0; i < this.getCellCount(); ++i) {
            this.m_Data.setMissing(i);
        }
    }

    public void assign(Row row) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (!row.hasCell(i) || row.getCell(i).isMissing()) {
                this.m_Data.setMissing(i);
                continue;
            }
            this.getCell(i).assign(row.getCell(i));
        }
    }

    public Cell newCell(Row owner) {
        throw new NotImplementedException();
    }

    public boolean hasCell(int columnIndex) {
        return columnIndex >= 0 && columnIndex < this.m_Data.numAttributes();
    }

    public boolean hasCell(String cellKey) {
        return this.hasCell(this.cellKeyToIndex(cellKey));
    }

    public Cell addCell(int columnIndex) {
        if (this.hasCell(columnIndex)) {
            return this.getCell(columnIndex);
        }
        return null;
    }

    public void spreadSheetColumnInserted(SpreadSheetColumnInsertionEvent e) {
    }
}

