/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.regression;

import adams.core.option.OptionUtils;
import adams.ml.capabilities.Capabilities;
import adams.ml.data.Dataset;
import adams.ml.data.WekaConverter;
import adams.ml.model.regression.AbstractRegressor;
import adams.ml.model.regression.RegressionModel;
import adams.ml.model.regression.WekaRegressionModel;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegressionJ;
import weka.core.Instances;

public class WekaRegressor
extends AbstractRegressor {
    private static final long serialVersionUID = -4086036132431888958L;
    protected Classifier m_Classifier;

    public String globalInfo() {
        return "Wraps around a Weka classifier that handles numeric classes (= regression).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new LinearRegressionJ());
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.assign(WekaConverter.convertCapabilities(this.m_Classifier.getCapabilities()));
        return result;
    }

    protected RegressionModel doBuildModel(Dataset data) throws Exception {
        Instances inst = WekaConverter.toInstances(data);
        Classifier classifier = (Classifier)OptionUtils.shallowCopy((Object)this.m_Classifier);
        if (classifier == null) {
            throw new Exception("Failed to create shallow copy of classifier: " + OptionUtils.getCommandLine((Object)this.m_Classifier));
        }
        classifier.buildClassifier(inst);
        return new WekaRegressionModel(classifier, data, inst);
    }
}

