/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.option.AbstractOptionHandler;
import adams.flow.container.WekaTrainTestSetContainer;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import weka.classifiers.SplitGenerator;
import weka.core.Instances;

public abstract class AbstractSplitGenerator
extends AbstractOptionHandler
implements SplitGenerator {
    private static final long serialVersionUID = -8387205583429213079L;
    protected long m_Seed;
    protected boolean m_UseViews;
    protected Instances m_Data;
    protected boolean m_Initialized;
    protected TIntList m_OriginalIndices;

    protected AbstractSplitGenerator() {
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("use-views", "useViews", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_OriginalIndices = new TIntArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
        this.m_OriginalIndices.clear();
    }

    @Override
    public void setData(Instances value) {
        this.m_Data = value != null ? new Instances(value) : null;
        this.reset();
    }

    @Override
    public Instances getData() {
        return this.m_Data;
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    @Override
    public void setUseViews(boolean value) {
        this.m_UseViews = value;
        this.reset();
    }

    @Override
    public boolean getUseViews() {
        return this.m_UseViews;
    }

    public String useViewsTipText() {
        return "If enabled, views are used instead of copies of the data.";
    }

    protected abstract boolean canRandomize();

    protected abstract boolean checkNext();

    @Override
    public synchronized boolean hasNext() {
        if (!this.m_Initialized) {
            this.initializeIterator();
        }
        return this.checkNext();
    }

    protected void randomize(TIntList indices, Random random) {
        for (int j = indices.size() - 1; j > 0; --j) {
            int i = random.nextInt(j + 1);
            int val = indices.get(j);
            indices.set(j, indices.get(i));
            indices.set(i, val);
        }
    }

    protected abstract void doInitializeIterator();

    @Override
    public void initializeIterator() {
        this.doInitializeIterator();
        this.m_Initialized = true;
    }

    protected abstract WekaTrainTestSetContainer createNext();

    @Override
    public synchronized WekaTrainTestSetContainer next() {
        if (!this.m_Initialized) {
            this.initializeIterator();
        }
        return this.createNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented!");
    }

    @Override
    public String toString() {
        return this.canRandomize() ? ", seed=" + this.m_Seed : "";
    }
}

