/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.option.OptionUtils;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.PLSClassifierWeightedWithLoadings;
import weka.classifiers.meta.ClassificationViaRegression;
import weka.classifiers.meta.ClassificationViaRegressionD;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PLSMatrixAccess;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;

public class ClassificationViaPLS
extends AbstractClassifier
implements PLSMatrixAccess {
    private static final long serialVersionUID = 8430850643799590721L;
    protected Instances m_Header;
    protected ClassificationViaRegressionD m_CVR;
    protected SingleIndex m_LabelIndex = new SingleIndex("first");
    protected String m_LabelString = "";

    public ClassificationViaPLS() {
        this.m_CVR = new ClassificationViaRegressionD();
        this.m_CVR.setClassifier((Classifier)new PLSClassifierWeightedWithLoadings());
    }

    public String globalInfo() {
        return "Performs " + ClassificationViaRegression.class.getSimpleName() + " using " + PLSClassifierWeightedWithLoadings.class.getSimpleName() + " as base classifier, allowing access to the PLS matrices.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe PLS filter to use. Full classname of filter to include, \tfollowed by scheme options.\n\t(default: " + ((PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier()).getDefaultFilter().getClass().getName() + ")", "filter", 1, "-filter <filter specification>"));
        result.addElement(new Option("\tThe label index (of the class attribute) to return the PLS matrices for.\n\t'first' and 'last' are accepted as well.\n\t(default: first)", "label-index", 1, "-label-index <num>"));
        result.addElement(new Option("\tThe label string (of the class attribute) to return the PLS matrices for.\n\tOverrides the '-label-index' option if non-empty.\n\t(default: '')", "label-string", 1, "-label-string <label>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        if (this.getFilter() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-filter'):"));
            en = this.getFilter().listOptions();
            while (en.hasMoreElements()) {
                result.addElement(en.nextElement());
            }
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-filter");
        if (this.getFilter() instanceof OptionHandler) {
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions((String[])this.getFilter().getOptions()));
        } else {
            result.add(this.getFilter().getClass().getName());
        }
        if (this.getLabelString().length() > 0) {
            result.add("-label-string");
            result.add("" + this.getLabelString());
        } else {
            result.add("-label-index");
            result.add("" + this.getLabelIndex());
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"filter", (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)OptionUtils.forName(Filter.class, (String)tmpStr, (String[])tmpOptions));
        } else {
            this.setFilter((Filter)((PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier()).getDefaultFilter());
        }
        tmpStr = Utils.getOption((String)"label-index", (String[])options);
        if (tmpStr.length() != 0) {
            this.setLabelIndex(tmpStr);
        } else {
            this.setLabelIndex("first");
        }
        tmpStr = Utils.getOption((String)"label-string", (String[])options);
        if (tmpStr.length() != 0) {
            this.setLabelString(tmpStr);
        } else {
            this.setLabelString("");
        }
        super.setOptions(options);
    }

    public void setFilter(Filter value) throws Exception {
        ((PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier()).setFilter(value);
    }

    public Filter getFilter() {
        return ((PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier()).getFilter();
    }

    public String filterTipText() {
        return ((PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier()).filterTipText();
    }

    public void setLabelIndex(String value) {
        this.m_LabelIndex.setSingleIndex(value);
    }

    public String getLabelIndex() {
        return this.m_LabelIndex.getSingleIndex();
    }

    public String labelIndexTipText() {
        return "The index of the class attribute's label (1-based) to get the PLS matrices for; 'first' and 'last' are accepted as well.";
    }

    public void setLabelString(String value) {
        this.m_LabelString = value;
    }

    public String getLabelString() {
        return this.m_LabelString;
    }

    public String labelStringTipText() {
        return "The class attribute's label to get the PLS matrices for; 'first' and 'last' are accepted as well.";
    }

    public Capabilities getCapabilities() {
        return this.m_CVR.getCapabilities();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_Header = null;
        this.m_CVR.buildClassifier(data);
        this.m_Header = new Instances(data, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_CVR.classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_CVR.distributionForInstance(instance);
    }

    protected PLSClassifierWeightedWithLoadings getSelectedClassifier() {
        PLSClassifierWeightedWithLoadings result = null;
        if (this.m_Header != null) {
            if (this.m_LabelString.length() > 0) {
                if (this.m_Header.classAttribute().indexOfValue(this.m_LabelString) > -1) {
                    result = (PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier(this.m_Header.classAttribute().indexOfValue(this.m_LabelString));
                } else {
                    System.err.println(this.getClass().getName() + ": Failed to locate class label '" + this.m_LabelString + "'!");
                }
            } else {
                this.m_LabelIndex.setUpper(this.m_Header.classAttribute().numValues() - 1);
                result = (PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier(this.m_LabelIndex.getIndex());
            }
        } else {
            System.err.println(this.getClass().getName() + ": classifier not built? Cannot retrieve base classifier!");
        }
        if (result == null) {
            result = (PLSClassifierWeightedWithLoadings)this.m_CVR.getClassifier();
        }
        return result;
    }

    @Override
    public Matrix getPLS1RegVector() {
        return this.getSelectedClassifier().getPLS1RegVector();
    }

    @Override
    public Matrix getPLS1P() {
        return this.getSelectedClassifier().getPLS1P();
    }

    @Override
    public Matrix getPLS1W() {
        return this.getSelectedClassifier().getPLS1W();
    }

    @Override
    public Matrix getPLS1bHat() {
        return this.getSelectedClassifier().getPLS1bHat();
    }

    @Override
    public Matrix getSimplsW() {
        return this.getSelectedClassifier().getSimplsW();
    }

    @Override
    public Matrix getSimplsB() {
        return this.getSelectedClassifier().getSimplsB();
    }

    public String getRevision() {
        return "$Revision$";
    }

    public String toString() {
        return this.m_CVR.toString();
    }

    public static void main(String[] args) {
        ClassificationViaPLS.runClassifier((Classifier)new ClassificationViaPLS(), (String[])args);
    }
}

