/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.WekaException;

public class Consensus
extends MultipleClassifiersCombiner
implements AbstainingClassifier {
    private static final long serialVersionUID = 4801293402527570640L;
    protected Index m_Predictor = new Index("1");

    public String globalInfo() {
        return "Outputs predictions only if the ensemble agrees. In case of agreement, the classifier identified by the 'predictor' index is used for making the actual prediction.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe index of the classifier for making the actual predictions.\n\t(default: 1)\n", "predictor", 1, "-predictor <1-based index>"));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-predictor");
        result.add(this.getPredictor().getIndex());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"predictor", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setPredictor(new Index(tmpStr));
        } else {
            this.setPredictor(new Index("1"));
        }
        super.setOptions(options);
    }

    public void setPredictor(Index value) {
        this.m_Predictor = value;
    }

    public Index getPredictor() {
        return this.m_Predictor;
    }

    public String predictorTipText() {
        return "The index (1-based) of the classifier to make the actual predictions.";
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_Predictor.setMax(this.m_Classifiers.length);
        if (this.m_Predictor.getIntIndex() == -1) {
            throw new WekaException("Failed to determine predictor index using: " + this.m_Predictor);
        }
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.m_Classifiers[i].buildClassifier(data);
        }
    }

    protected boolean consensus(Instance instance) throws Exception {
        double first = Utils.missingValue();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            if (i == 0) {
                first = this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double next = this.m_Classifiers[i].classifyInstance(instance);
            if (next == first) continue;
            return false;
        }
        return true;
    }

    public double classifyInstance(Instance instance) throws Exception {
        double result = this.consensus(instance) ? this.m_Classifiers[this.m_Predictor.getIntIndex()].classifyInstance(instance) : Utils.missingValue();
        return result;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = this.consensus(instance) ? this.m_Classifiers[this.m_Predictor.getIntIndex()].distributionForInstance(instance) : new double[instance.numClasses()];
        return result;
    }

    @Override
    public boolean canAbstain() {
        return this.m_Classifiers.length > 1;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        return this.m_Classifiers[this.m_Predictor.getIntIndex()].classifyInstance(inst);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        return this.m_Classifiers[this.m_Predictor.getIntIndex()].distributionForInstance(inst);
    }
}

