/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.meta.Vote;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ModelOutputHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class ConsensusOrVote
extends MultipleClassifiersCombiner
implements ModelOutputHandler,
AbstainingClassifier {
    private static final long serialVersionUID = 943666951855888860L;
    public static final String SUPPORT = "support";
    public static final String SUPPRESS_MODEL_OUTPUT = "suppress-model-output";
    protected double m_Support = this.getDefaultSupport();
    protected int m_ActualSupport;
    protected Vote m_Vote = null;
    protected boolean m_SuppressModelOutput = false;

    public String globalInfo() {
        return "If the required minimum number of classifiers of the ensemble agree on a label, then this label is predicted. Otherwise, Vote with majority rule is used.";
    }

    protected double getDefaultSupport() {
        return 1.0;
    }

    public void setSupport(double value) {
        if (value > 0.0) {
            this.m_Support = value;
        } else {
            System.err.println("Support must meet >0, provided: " + value);
        }
    }

    public double getSupport() {
        return this.m_Support;
    }

    public String supportTipText() {
        return "The percentage (0-1 excl) or number of base-classifiers (>= 1) that need to chose the label in order to predict it";
    }

    @Override
    public void setSuppressModelOutput(boolean value) {
        this.m_SuppressModelOutput = value;
    }

    @Override
    public boolean getSuppressModelOutput() {
        return this.m_SuppressModelOutput;
    }

    @Override
    public String suppressModelOutputTipText() {
        return "If enabled, suppresses any large model output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.supportTipText(), "" + this.getDefaultSupport(), SUPPORT);
        WekaOptionUtils.addFlag(result, this.suppressModelOutputTipText(), SUPPRESS_MODEL_OUTPUT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setSupport(WekaOptionUtils.parse(options, SUPPORT, this.getDefaultSupport()));
        this.setSuppressModelOutput(Utils.getFlag((String)SUPPRESS_MODEL_OUTPUT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, SUPPORT, this.getSupport());
        WekaOptionUtils.add(result, SUPPRESS_MODEL_OUTPUT, this.getSuppressModelOutput());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.DATE_CLASS);
        result.disable(Capabilities.Capability.NUMERIC_CLASS);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_ActualSupport = this.m_Support >= 1.0 ? (int)this.m_Support : (int)Math.round(this.m_Support * (double)this.m_Classifiers.length);
        if (this.getDebug()) {
            System.out.println("Actual support: " + this.m_ActualSupport);
        }
        this.m_Vote = new Vote();
        this.m_Vote.setCombinationRule(new SelectedTag(3, Vote.TAGS_RULES));
        this.m_Vote.setClassifiers(this.m_Classifiers);
        this.m_Vote.buildClassifier(data);
    }

    protected boolean isAbstaining(Instance instance) throws Exception {
        int i;
        int[] support = new int[instance.classAttribute().numValues()];
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            double label = this.m_Classifiers[i].classifyInstance(instance);
            if (Utils.isMissingValue((double)label)) continue;
            int n = (int)label;
            support[n] = support[n] + 1;
        }
        int highestIndex = -1;
        int highestCount = 0;
        for (i = 0; i < support.length; ++i) {
            if (support[i] <= 0 || support[i] <= highestCount) continue;
            highestIndex = i;
            highestCount = support[i];
        }
        if (support[highestIndex] < this.m_ActualSupport) {
            highestIndex = -1;
        }
        return highestIndex == -1;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.canAbstain() && this.isAbstaining(instance)) {
            return new double[instance.classAttribute().numValues()];
        }
        return this.m_Vote.distributionForInstance(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.canAbstain() && this.isAbstaining(instance)) {
            return Utils.missingValue();
        }
        return this.m_Vote.classifyInstance(instance);
    }

    @Override
    public boolean canAbstain() {
        return this.m_Classifiers.length > 1;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        return this.m_Vote.classifyInstance(inst);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        return this.m_Vote.distributionForInstance(inst);
    }

    public String toString() {
        if (this.m_Vote == null) {
            return "No model built yet";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n\n");
        result.append("Can abstain: " + this.canAbstain() + "\n");
        result.append("Support: " + this.m_Support + "\n");
        result.append("Actual support: " + this.m_ActualSupport + "\n");
        if (!this.m_SuppressModelOutput) {
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                result.append("\n");
                result.append("Classifier #" + (i + 1) + "\n");
                result.append(new String("Classifier #" + (i + 1)).replaceAll(".", "-") + "\n\n");
                result.append(this.m_Classifiers[i].toString());
            }
        }
        return result.toString();
    }
}

