/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.Tokenizer;

public class MultiTokenizer
extends Tokenizer {
    private static final long serialVersionUID = 6094968316580671771L;
    public static final String TOKENIZER = "tokenizer";
    protected Tokenizer[] m_Tokenizers = this.getDefaultTokenizers();
    protected List<String> m_Tokens = new ArrayList<String>();

    public String globalInfo() {
        return "Combines the tokens of several tokenizers, skipping duplicate tokens.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.tokenizersTipText(), "none", TOKENIZER);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setTokenizers((Tokenizer[])WekaOptionUtils.parse(options, TOKENIZER, (OptionHandler[])this.getDefaultTokenizers(), Tokenizer.class));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, TOKENIZER, (Object)this.getTokenizers());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected Tokenizer[] getDefaultTokenizers() {
        return new Tokenizer[0];
    }

    public void setTokenizers(Tokenizer[] value) {
        this.m_Tokenizers = value;
    }

    public Tokenizer[] getTokenizers() {
        return this.m_Tokenizers;
    }

    public String tokenizersTipText() {
        return "The tokenizers to apply.";
    }

    public boolean hasMoreElements() {
        return this.m_Tokens.size() > 0;
    }

    public String nextElement() {
        return this.m_Tokens.remove(0);
    }

    public void tokenize(String s) {
        this.m_Tokens.clear();
        HashSet<String> tokens = new HashSet<String>();
        for (Tokenizer t : this.m_Tokenizers) {
            t.tokenize(s);
            while (t.hasMoreElements()) {
                String token = t.nextElement();
                if (tokens.contains(token)) continue;
                this.m_Tokens.add(token);
                tokens.add(token);
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }
}

