/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers.cleaners;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.OptionHandler;
import weka.core.WekaOptionUtils;
import weka.core.tokenizers.cleaners.AbstractTokenCleaner;
import weka.core.tokenizers.cleaners.TokenCleaner;

public class MultiCleaner
extends AbstractTokenCleaner {
    private static final long serialVersionUID = -1815343837519097597L;
    public static final String CLEANER = "cleaner";
    protected TokenCleaner[] m_Cleaners = this.getDefaultCleaners();

    @Override
    public String globalInfo() {
        return "Combines multiple cleaners, applies them sequentially.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.cleanersTipText(), "none", CLEANER);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setCleaners((TokenCleaner[])WekaOptionUtils.parse(options, CLEANER, (OptionHandler[])this.getDefaultCleaners(), TokenCleaner.class));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, CLEANER, (Object)this.getCleaners());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected TokenCleaner[] getDefaultCleaners() {
        return new TokenCleaner[0];
    }

    public void setCleaners(TokenCleaner[] value) {
        this.m_Cleaners = value;
        this.reset();
    }

    public TokenCleaner[] getCleaners() {
        return this.m_Cleaners;
    }

    public String cleanersTipText() {
        return "The cleaners to apply sequentially.";
    }

    @Override
    public String clean(String token) {
        TokenCleaner cleaner;
        String result = token;
        TokenCleaner[] tokenCleanerArray = this.m_Cleaners;
        int n = tokenCleanerArray.length;
        for (int i = 0; i < n && (result = (cleaner = tokenCleanerArray[i]).clean(result)) != null; ++i) {
        }
        return result;
    }
}

