/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.UnorderedRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class KeepRange
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 4444860420131316510L;
    protected UnorderedRange m_RowRange = new UnorderedRange("first-last");

    public String globalInfo() {
        return "Keeps only the range of rows, in the order specified.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe unordered range of rows to keep, using 1-based indices.\n\t(default: first-last).", "R", 1, "-R <unordered_range>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setRowRange(tmpStr);
        } else {
            this.setRowRange("first-last");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add(this.getRowRange());
        return result.toArray(new String[result.size()]);
    }

    public void setRowRange(String value) {
        if (UnorderedRange.isValid((String)value, (int)-1)) {
            this.m_RowRange.setRange(value);
            this.reset();
        }
    }

    public String getRowRange() {
        return this.m_RowRange.getRange();
    }

    public String rowRangeTipText() {
        return "The unordered range of rows to keep; " + this.m_RowRange.getExample();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        this.m_RowRange.setMax(instances.numInstances());
        int[] indices = this.m_RowRange.getIntIndices();
        Instances result = new Instances(instances, indices.length);
        for (int index : indices) {
            result.add((Instance)instances.instance(index).copy());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        KeepRange.runFilter((Filter)new KeepRange(), (String[])args);
    }
}

