/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka;

import adams.core.UnorderedRange;
import adams.core.UnorderedRangeTest;
import adams.data.weka.WekaUnorderedAttributeRange;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaUnorderedAttributeRangeTest
extends UnorderedRangeTest {
    protected Instances m_Data;

    public WekaUnorderedAttributeRangeTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.arff";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Data = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
        if (this.m_Data == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        super.tearDown();
    }

    protected UnorderedRange newRange(String index, int max) {
        if (index == null) {
            return new WekaUnorderedAttributeRange();
        }
        return new WekaUnorderedAttributeRange(index, max);
    }

    public void testColumnNames() {
        int i;
        WekaUnorderedAttributeRange range = new WekaUnorderedAttributeRange("first-last");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"first-last", (String)range.getRange());
        range.setData(null);
        range.setRange("blah");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"blah", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duration");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"duration", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("\"duration\"");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"\"duration\"", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("Duration");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should not be valid", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"Duration", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duratoin");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"duratoin", (String)range.getRange());
        range.setData(null);
        range.setRange("class-duration");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"class-duration", (String)range.getRange());
        range.setData(null);
        range.setRange("class-duration");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"class-duration", (String)range.getRange());
        range.setData(null);
        range.setRange("\"class\"-\"duration\"");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"\"class\"-\"duration\"", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duration-class");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)17, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"duration-class", (String)range.getRange());
        for (i = 0; i < this.m_Data.numAttributes(); ++i) {
            WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)i, (int)range.getIntIndices()[i]);
        }
        range.setData((Object)this.m_Data);
        range.setRange("class,duration");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"class,duration", (String)range.getRange());
        this.assertEqualsArrays("should be the same", new int[]{16, 0}, range.getIntIndices());
        range.setData((Object)this.m_Data);
        range.setRange("\"duration\"-\"class\"");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)17, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"\"duration\"-\"class\"", (String)range.getRange());
        for (i = 0; i < this.m_Data.numAttributes(); ++i) {
            WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)i, (int)range.getIntIndices()[i]);
        }
    }

    public void testSpecialColumnNames() {
        WekaUnorderedAttributeRange range = new WekaUnorderedAttributeRange();
        range.setData((Object)this.m_Data);
        range.setRange("\"shift-differential\"");
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be valid", (int)8, (int)range.getIntIndices()[0]);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"should be same", (String)"\"shift-differential\"", (String)range.getRange());
    }

    public void testSubstrings() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("blah"));
        atts.add(new Attribute("dbtimestamp"));
        atts.add(new Attribute("time"));
        Instances data = new Instances("test", atts, 0);
        WekaUnorderedAttributeRange range = new WekaUnorderedAttributeRange();
        range.setRange("bloerk");
        range.setData((Object)data);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"shouldn't find any cols", (int)0, (int)range.getIntIndices().length);
        range = new WekaUnorderedAttributeRange();
        range.setRange("dbtimestamp");
        range.setData((Object)data);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"index differs", (int)1, (int)range.getIntIndices()[0]);
        range = new WekaUnorderedAttributeRange();
        range.setRange("time");
        range.setData((Object)data);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"index differs", (int)2, (int)range.getIntIndices()[0]);
        range = new WekaUnorderedAttributeRange();
        range.setRange("blah");
        range.setData((Object)data);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaUnorderedAttributeRangeTest.assertEquals((String)"index differs", (int)0, (int)range.getIntIndices()[0]);
    }

    public static Test suite() {
        return new TestSuite(WekaUnorderedAttributeRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaUnorderedAttributeRangeTest.runTest((Test)WekaUnorderedAttributeRangeTest.suite());
    }
}

