/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SetStorageValue;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaInstanceBuffer;
import adams.flow.transformer.WekaNearestNeighborSearch;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.SimpleArffLoader;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Randomize;
import weka.filters.unsupervised.instance.RemovePercentage;

public class WekaNearestNeighborSearchTest
extends AbstractFlowTest {
    public WekaNearestNeighborSearchTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaNearestNeighborSearchTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/iris.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            SimpleArffLoader simplearffloader = new SimpleArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)simplearffloader);
            actors.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors.add(wekaclassselector);
            SetStorageValue setstoragevalue = new SetStorageValue();
            argOption = (AbstractArgumentOption)setstoragevalue.getOptionManager().findByProperty("storageName");
            setstoragevalue.setStorageName((StorageName)argOption.valueOf("data"));
            actors.add(setstoragevalue);
            WekaFilter wekafilter = new WekaFilter();
            argOption = (AbstractArgumentOption)wekafilter.getOptionManager().findByProperty("name");
            wekafilter.setName((String)argOption.valueOf("randomize"));
            Randomize randomize = new Randomize();
            randomize.setOptions(OptionUtils.splitOptions((String)"-S 42"));
            wekafilter.setFilter((Filter)randomize);
            wekafilter.setKeepRelationName(true);
            actors.add(wekafilter);
            WekaFilter wekafilter2 = new WekaFilter();
            RemovePercentage removepercentage = new RemovePercentage();
            removepercentage.setOptions(OptionUtils.splitOptions((String)"-P 95.0"));
            wekafilter2.setFilter((Filter)removepercentage);
            wekafilter2.setKeepRelationName(true);
            actors.add(wekafilter2);
            WekaInstanceBuffer wekainstancebuffer = new WekaInstanceBuffer();
            argOption = (AbstractArgumentOption)wekainstancebuffer.getOptionManager().findByProperty("operation");
            wekainstancebuffer.setOperation((WekaInstanceBuffer.Operation)argOption.valueOf("INSTANCES_TO_INSTANCE"));
            actors.add(wekainstancebuffer);
            WekaNearestNeighborSearch wekanearestneighborsearch = new WekaNearestNeighborSearch();
            LinearNNSearch linearnnsearch = new LinearNNSearch();
            linearnnsearch.setOptions(OptionUtils.splitOptions((String)"-A \"weka.core.EuclideanDistance -R first-last\""));
            wekanearestneighborsearch.setSearch((NearestNeighbourSearch)linearnnsearch);
            argOption = (AbstractArgumentOption)wekanearestneighborsearch.getOptionManager().findByProperty("storage");
            wekanearestneighborsearch.setStorage((StorageName)argOption.valueOf("data"));
            actors.add(wekanearestneighborsearch);
            ContainerValuePicker containervaluepicker = new ContainerValuePicker();
            argOption = (AbstractArgumentOption)containervaluepicker.getOptionManager().findByProperty("valueName");
            containervaluepicker.setValueName((String)argOption.valueOf("Neighborhood"));
            containervaluepicker.setSwitchOutputs(true);
            actors.add(containervaluepicker);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            dumpfile.setAppend(true);
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaNearestNeighborSearchTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaNearestNeighborSearchTest.runTest((Test)WekaNearestNeighborSearchTest.suite());
    }
}

