/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaAssociatorSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.CollectionToSequence;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaTrainAssociator;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.associations.Apriori;
import weka.associations.Associator;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.SimpleArffLoader;

public class WekaTrainAssociatorTest
extends AbstractFlowTest {
    public WekaTrainAssociatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaTrainAssociatorTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CallableActors callableactors = new CallableActors();
            ArrayList<WekaAssociatorSetup> actors2 = new ArrayList<WekaAssociatorSetup>();
            WekaAssociatorSetup wekaassociatorsetup = new WekaAssociatorSetup();
            Apriori apriori = new Apriori();
            apriori.setOptions(OptionUtils.splitOptions((String)"-N 10 -T 0 -C 0.9 -D 0.05 -U 1.0 -M 0.1 -S -1.0 -c -1 \"\" \"\" \"\" \"\" \"\" \"\" \"\""));
            wekaassociatorsetup.setAssociator((Associator)apriori);
            actors2.add(wekaassociatorsetup);
            callableactors.setActors(actors2.toArray(new Actor[0]));
            actors.add(callableactors);
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/vote.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            WekaFileReader wekafilereader = new WekaFileReader();
            SimpleArffLoader simplearffloader = new SimpleArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)simplearffloader);
            actors.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors.add(wekaclassselector);
            WekaTrainAssociator wekatrainassociator = new WekaTrainAssociator();
            actors.add(wekatrainassociator);
            ContainerValuePicker containervaluepicker = new ContainerValuePicker();
            argOption = (AbstractArgumentOption)containervaluepicker.getOptionManager().findByProperty("valueName");
            containervaluepicker.setValueName((String)argOption.valueOf("Rules"));
            containervaluepicker.setSwitchOutputs(true);
            actors.add(containervaluepicker);
            CollectionToSequence collectiontosequence = new CollectionToSequence();
            actors.add(collectiontosequence);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            dumpfile.setAppend(true);
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WekaTrainAssociatorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaTrainAssociatorTest.runTest((Test)WekaTrainAssociatorTest.suite());
    }
}

