/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.filter;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.filter.AbstractTrainableSpreadSheetFilter;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class WekaFilter
extends AbstractTrainableSpreadSheetFilter {
    private static final long serialVersionUID = 7531941908565712012L;
    protected Filter m_Filter;
    protected Filter m_ActualFilter;
    protected int m_MaxLabels;

    public String globalInfo() {
        return "Applies the specified Weka filter to the spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AllFilter());
        this.m_OptionManager.add("max-labels", "maxLabels", (Object)25, (Number)-1, null);
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
        this.reset();
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the spreadsheet.";
    }

    public void setMaxLabels(int value) {
        if (this.getOptionManager().isValid("maxLabels", (Number)value)) {
            this.m_MaxLabels = value;
            this.reset();
        }
    }

    public int getMaxLabels() {
        return this.m_MaxLabels;
    }

    public String maxLabelsTipText() {
        return "The maximum number of labels that a NOMINAL attribute can have before it is switched to a STRING attribute; use -1 to enforce STRING attributes.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)this.m_Filter, (String)"filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxLabels", (Object)this.m_MaxLabels, (String)", max-labels: ");
        return result;
    }

    protected Instances toInstances(SpreadSheet data) {
        SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
        conv.setMaxLabels(this.m_MaxLabels);
        conv.setInput(data);
        String msg = conv.convert();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        Instances result = (Instances)conv.getOutput();
        conv.cleanUp();
        return result;
    }

    protected SpreadSheet toSpreadSheet(Instances data) {
        WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
        conv.setInput(data);
        String msg = conv.convert();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        SpreadSheet result = (SpreadSheet)conv.getOutput();
        conv.cleanUp();
        return result;
    }

    protected SpreadSheet doTrain(SpreadSheet data) throws Exception {
        this.m_ActualFilter = (Filter)ObjectCopyHelper.copyObject((Object)this.m_Filter);
        Instances inst = this.toInstances(data);
        this.m_ActualFilter.setInputFormat(inst);
        Instances filtered = Filter.useFilter((Instances)inst, (Filter)this.m_ActualFilter);
        return this.toSpreadSheet(filtered);
    }

    protected SpreadSheet doFilter(SpreadSheet data) throws Exception {
        Instances inst = this.toInstances(data);
        Instances filtered = Filter.useFilter((Instances)inst, (Filter)this.m_ActualFilter);
        return this.toSpreadSheet(filtered);
    }
}

