/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.AttributeTransformer;
import weka.core.Instances;

public class WekaAttributeSelectionContainer
extends AbstractContainer {
    private static final long serialVersionUID = -5748659421111306695L;
    public static final String VALUE_TRAIN = "Train";
    public static final String VALUE_REDUCED = "Reduced";
    public static final String VALUE_TRANSFORMED = "Transformed";
    public static final String VALUE_TEST = "Test";
    public static final String VALUE_TEST_REDUCED = "Test reduced";
    public static final String VALUE_TEST_TRANSFORMED = "Test transformed";
    public static final String VALUE_EVALUATION = "Evaluation";
    public static final String VALUE_STATISTICS = "Statistics";
    public static final String VALUE_SELECTEDATTRIBUTES = "Selected attributes";
    public static final String VALUE_SEED = "Seed";
    public static final String VALUE_FOLD_COUNT = "FoldCount";

    public WekaAttributeSelectionContainer() {
        this(null, null, null, null, null, null, null, null);
    }

    public WekaAttributeSelectionContainer(Instances train, Instances reduced, Instances transformed, AttributeSelection eval, SpreadSheet statistics, String range) {
        this(train, reduced, transformed, eval, statistics, range, null, null);
    }

    public WekaAttributeSelectionContainer(Instances train, Instances reduced, Instances transformed, AttributeSelection eval, Long seed, Integer foldCount) {
        this(train, reduced, transformed, eval, null, null, seed, foldCount);
    }

    protected WekaAttributeSelectionContainer(Instances train, Instances reduced, Instances transformed, AttributeSelection eval, SpreadSheet statistics, String range, Long seed, Integer foldCount) {
        this.store(VALUE_TRAIN, train);
        this.store(VALUE_REDUCED, reduced);
        this.store(VALUE_TRANSFORMED, transformed);
        this.store(VALUE_EVALUATION, eval);
        this.store(VALUE_STATISTICS, statistics);
        this.store(VALUE_SELECTEDATTRIBUTES, range);
        this.store(VALUE_SEED, seed);
        this.store(VALUE_FOLD_COUNT, foldCount);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_TRAIN, "training set", Instances.class);
        this.addHelp(VALUE_REDUCED, "reduced dataset", Instances.class);
        this.addHelp(VALUE_TRANSFORMED, "transformed dataset (if " + Utils.classToString(AttributeTransformer.class) + ")", Instances.class);
        this.addHelp(VALUE_TEST, "test set", Instances.class);
        this.addHelp(VALUE_TEST_REDUCED, "reduced test dataset", Instances.class);
        this.addHelp(VALUE_TEST_TRANSFORMED, "transformed test dataset (if " + Utils.classToString(AttributeTransformer.class) + ")", Instances.class);
        this.addHelp(VALUE_EVALUATION, "attribute selection evaluation object", AttributeSelection.class);
        this.addHelp(VALUE_STATISTICS, "spreadsheet with the statistics", SpreadSheet.class);
        this.addHelp(VALUE_SELECTEDATTRIBUTES, "range string of selected attributes (1-based indices)", String.class);
        this.addHelp(VALUE_SEED, "seed value (cross-validation)", Long.class);
        this.addHelp(VALUE_FOLD_COUNT, "fold (cross-validation)", Integer.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_TRAIN);
        result.add(VALUE_REDUCED);
        result.add(VALUE_TRANSFORMED);
        result.add(VALUE_TEST);
        result.add(VALUE_TEST_REDUCED);
        result.add(VALUE_TEST_TRANSFORMED);
        result.add(VALUE_EVALUATION);
        result.add(VALUE_STATISTICS);
        result.add(VALUE_SELECTEDATTRIBUTES);
        result.add(VALUE_SEED);
        result.add(VALUE_FOLD_COUNT);
        return result.iterator();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_TRAIN) && this.hasValue(VALUE_EVALUATION) && !this.hasValue(VALUE_SEED) && !this.hasValue(VALUE_FOLD_COUNT)) | (this.hasValue(VALUE_TRAIN) && this.hasValue(VALUE_EVALUATION) && this.hasValue(VALUE_SEED) && this.hasValue(VALUE_FOLD_COUNT));
    }
}

