/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaExperimentContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;

public class WekaExperimentExecution
extends AbstractTransformer {
    private static final long serialVersionUID = 5060803438523115907L;
    protected boolean m_OverrideJobRunner;
    protected JobRunner m_JobRunner;
    protected transient AbstractExperiment m_Experiment;

    public String globalInfo() {
        return "Executes an experiment. The jobrunner of the experiment can be overriden.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("override-jobrunner", "overrideJobRunner", (Object)false);
        this.m_OptionManager.add("jobrunner", "jobRunner", (Object)new LocalJobRunner());
    }

    public void setOverrideJobRunner(boolean value) {
        this.m_OverrideJobRunner = value;
        this.reset();
    }

    public boolean getOverrideJobRunner() {
        return this.m_OverrideJobRunner;
    }

    public String overrideJobRunnerTipText() {
        return "If enabled, the jobrunner of the experiments gets replaced with the one specified here.";
    }

    public void setJobRunner(JobRunner value) {
        this.m_JobRunner = value;
        this.reset();
    }

    public JobRunner getJobRunner() {
        return this.m_JobRunner;
    }

    public String jobRunnerTipText() {
        return "The JobRunner to use for processing the jobs.";
    }

    public String getQuickInfo() {
        if (this.m_OverrideJobRunner) {
            return QuickInfoHelper.toString((OptionHandler)this, (String)"jobRunner", (Object)this.m_JobRunner, (String)"jobrunner: ");
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{AbstractExperiment.class};
    }

    public Class[] generates() {
        return new Class[]{WekaExperimentContainer.class};
    }

    protected String doExecute() {
        String result;
        this.m_Experiment = (AbstractExperiment)this.m_InputToken.getPayload();
        if (this.m_OverrideJobRunner) {
            this.m_Experiment = (AbstractExperiment)ObjectCopyHelper.copyObject((Object)this.m_Experiment);
            this.m_Experiment.setJobRunner(this.m_JobRunner);
        }
        if ((result = this.m_Experiment.execute()) == null) {
            WekaExperimentContainer cont = new WekaExperimentContainer(this.m_Experiment, this.m_Experiment.toInstances(), this.m_Experiment.toSpreadSheet());
            this.m_OutputToken = new Token((Object)cont);
        }
        this.m_Experiment = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_Experiment != null) {
            this.m_Experiment.stopExecution();
        }
        super.stopExecution();
    }
}

