/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.tools.wekamultiexperimenter.io.AbstractExperimentIO;
import adams.gui.tools.wekamultiexperimenter.io.DefaultAdamsExperimentIO;
import java.io.File;

public class WekaExperimentFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 4825322750521498988L;
    protected AbstractExperimentIO m_Handler;

    public String globalInfo() {
        return "Loads an experiment file.\nSupported file formats of current handler: " + Utils.flatten((Object[])this.m_Handler.getSupportedFileExtensions(true), (String)",");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)this.getDefaultHandler());
    }

    protected AbstractExperimentIO getDefaultHandler() {
        return new DefaultAdamsExperimentIO();
    }

    public void setHandler(AbstractExperimentIO value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractExperimentIO getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The I/O handler to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"handler", (Object)((Object)this.m_Handler), (String)"handler: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{this.m_Handler.getExperimentClass()};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
        Object exp = this.m_Handler.load(file.getAbsoluteFile());
        if (exp == null) {
            result = "Failed to load experiment: " + file;
        } else {
            this.m_OutputToken = new Token(exp);
        }
        return result;
    }
}

