/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.io.ModelFileHandler;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.instance.Instance;
import adams.flow.container.OptionalContainerOutput;
import adams.flow.container.WekaFilterContainer;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.AbstractModelLoader;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.FlowContextHandler;
import adams.flow.core.ModelLoaderSupporter;
import adams.flow.core.OptionalOneTimeInitializer;
import adams.flow.core.Token;
import adams.flow.core.WekaFilterModelLoader;
import adams.flow.transformer.AbstractTransformerWithPropertiesUpdating;
import java.util.Hashtable;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class WekaFilter
extends AbstractTransformerWithPropertiesUpdating
implements OptionalContainerOutput,
ModelFileHandler,
StorageUser,
ModelLoaderSupporter,
OptionalOneTimeInitializer {
    private static final long serialVersionUID = 9078845385089445202L;
    public static final String BACKUP_INITIALIZED = "initialized";
    protected Filter m_Filter;
    protected Filter m_ActualFilter;
    protected boolean m_InitializeOnce;
    protected boolean m_KeepRelationName;
    protected boolean m_OutputContainer;
    protected boolean m_Initialized;
    protected boolean m_FlowContextUpdated;
    protected WekaFilterModelLoader m_ModelLoader;

    public String globalInfo() {
        return "Filters Instances/Instance objects using the specified filter.\nWhen re-using a trained filter, ensure that 'initializeOnce' is checked.\n\n" + this.m_ModelLoader.automaticOrderInfo();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AllFilter());
        this.m_OptionManager.add("model-loading-type", "modelLoadingType", (Object)AbstractModelLoader.ModelLoadingType.AUTO);
        this.m_OptionManager.add("model", "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("source", "modelActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("storage", "modelStorage", (Object)new StorageName());
        this.m_OptionManager.add("init-once", "initializeOnce", (Object)false);
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
        this.m_OptionManager.add("output-container", "outputContainer", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_ModelLoader = new WekaFilterModelLoader();
        this.m_ModelLoader.setFlowContext((Actor)this);
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_ModelLoader.setLoggingLevel(value);
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
        this.reset();
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the Instances/Instance objects.";
    }

    public void setModelLoadingType(AbstractModelLoader.ModelLoadingType value) {
        this.m_ModelLoader.setModelLoadingType(value);
        this.reset();
    }

    public AbstractModelLoader.ModelLoadingType getModelLoadingType() {
        return this.m_ModelLoader.getModelLoadingType();
    }

    public String modelLoadingTypeTipText() {
        return this.m_ModelLoader.modelLoadingTypeTipText();
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelLoader.setModelFile(value);
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelLoader.getModelFile();
    }

    public String modelFileTipText() {
        return this.m_ModelLoader.modelFileTipText();
    }

    public void setModelActor(CallableActorReference value) {
        this.m_ModelLoader.setModelActor(value);
        this.reset();
    }

    public CallableActorReference getModelActor() {
        return this.m_ModelLoader.getModelActor();
    }

    public String modelActorTipText() {
        return this.m_ModelLoader.modelActorTipText();
    }

    public void setModelStorage(StorageName value) {
        this.m_ModelLoader.setModelStorage(value);
        this.reset();
    }

    public StorageName getModelStorage() {
        return this.m_ModelLoader.getModelStorage();
    }

    public String modelStorageTipText() {
        return this.m_ModelLoader.modelStorageTipText();
    }

    public void setInitializeOnce(boolean value) {
        this.m_InitializeOnce = value;
        this.reset();
    }

    public boolean getInitializeOnce() {
        return this.m_InitializeOnce;
    }

    public String initializeOnceTipText() {
        return "If set to true, then the filter will get initialized only with the first batch of data; otherwise every time data gets passed through; only applies when using the filter definition, the others (model file, source, storage) assume the filter to be built.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public void setOutputContainer(boolean value) {
        this.m_OutputContainer = value;
        this.reset();
    }

    public boolean getOutputContainer() {
        return this.m_OutputContainer;
    }

    public String outputContainerTipText() {
        return "If enabled, a " + WekaFilterContainer.class.getName() + " is output with the filter and the filtered data (Instance or Instances).";
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public Class[] generates() {
        if (this.m_OutputContainer) {
            return new Class[]{WekaFilterContainer.class};
        }
        return new Class[]{weka.core.Instance.class, Instances.class, Instance.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Filter), (int)40));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelLoadingType", (Object)this.getModelLoadingType(), (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)this.getModelFile(), (String)", model: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelSource", (Object)this.getModelActor(), (String)", source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelStorage", (Object)this.getModelStorage(), (String)", storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keepRelationName", (boolean)this.m_KeepRelationName, (String)"keep relation name", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputContainer", (boolean)this.m_OutputContainer, (String)"output container", (String)", ");
        String info = super.getQuickInfo();
        if (!info.isEmpty()) {
            result = result + ", " + info;
        }
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INITIALIZED);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INITIALIZED, this.m_Initialized);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INITIALIZED)) {
            this.m_Initialized = (Boolean)state.get(BACKUP_INITIALIZED);
            state.remove(BACKUP_INITIALIZED);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
        this.m_FlowContextUpdated = false;
        this.m_ModelLoader.reset();
    }

    public Class[] accepts() {
        return new Class[]{weka.core.Instance.class, Instances.class, Instance.class};
    }

    protected Token createToken(Object input, Object data) {
        if (this.m_OutputContainer) {
            WekaFilterContainer cont;
            if (data instanceof Instances) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (Instances)data);
            } else if (data instanceof weka.core.Instance) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (weka.core.Instance)data);
            } else if (data instanceof Instance) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (Instance)((Object)data));
            } else {
                throw new IllegalArgumentException("Unhandled data type: " + data.getClass().getName());
            }
            cont.setValue("Input", input);
            return new Token((Object)cont);
        }
        return new Token(data);
    }

    protected String initActualFilter(Instances data) throws Exception {
        String result;
        MessageCollection errors = new MessageCollection();
        boolean initFilter = false;
        this.m_ActualFilter = (Filter)this.m_ModelLoader.getModel(errors);
        if (this.m_ActualFilter == null) {
            initFilter = true;
            if (this.getModelLoadingType() == AbstractModelLoader.ModelLoadingType.AUTO) {
                this.m_ActualFilter = (Filter)ObjectCopyHelper.copyObject((Object)this.m_Filter);
            } else {
                return errors.toString();
            }
        }
        if ((result = this.setUpContainers(this.m_ActualFilter)) == null) {
            result = this.updateObject(this.m_ActualFilter);
        }
        if (!this.m_InitializeOnce || initFilter) {
            this.m_ActualFilter.setInputFormat(data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        Instances data = null;
        weka.core.Instance inst = null;
        if (this.m_InputToken.hasPayload(weka.core.Instance.class)) {
            inst = (weka.core.Instance)this.m_InputToken.getPayload(weka.core.Instance.class);
        } else if (this.m_InputToken.hasPayload(Instance.class)) {
            inst = ((Instance)((Object)this.m_InputToken.getPayload(Instance.class))).toInstance();
        } else if (this.m_InputToken.hasPayload(Instances.class)) {
            data = (Instances)this.m_InputToken.getPayload(Instances.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            try {
                if (!this.m_Initialized || !this.m_InitializeOnce) {
                    if (data == null) {
                        data = new Instances(inst.dataset(), 0);
                        data.add(inst);
                    }
                    result = this.initActualFilter(data);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to initialize filter!", e);
            }
        }
        if (result == null) {
            try {
                weka.core.Instance filteredInst;
                Instances filteredData;
                Filter e = this.m_ActualFilter;
                synchronized (e) {
                    if (!this.m_FlowContextUpdated) {
                        this.m_FlowContextUpdated = true;
                        if (this.m_ActualFilter instanceof FlowContextHandler) {
                            ((FlowContextHandler)this.m_ActualFilter).setFlowContext((Actor)this);
                        }
                    }
                    filteredData = null;
                    filteredInst = null;
                    if (data != null) {
                        String relation = data.relationName();
                        filteredData = Filter.useFilter((Instances)data, (Filter)this.m_ActualFilter);
                        if (this.m_KeepRelationName) {
                            filteredData.setRelationName(relation);
                            if (this.isLoggingEnabled()) {
                                this.getLogger().info("Setting relation name: " + relation);
                            }
                        }
                        this.m_Initialized = true;
                    } else {
                        String relation = inst.dataset().relationName();
                        this.m_ActualFilter.input(inst);
                        this.m_ActualFilter.batchFinished();
                        filteredInst = this.m_ActualFilter.output();
                        if (this.m_KeepRelationName) {
                            filteredInst.dataset().setRelationName(relation);
                            if (this.isLoggingEnabled()) {
                                this.getLogger().info("Setting relation name: " + relation);
                            }
                        }
                    }
                }
                if (inst != null) {
                    if (filteredInst != null) {
                        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
                            this.m_OutputToken = new Token((Object)filteredInst);
                        } else {
                            Instance instA = new Instance();
                            instA.set(filteredInst);
                            this.m_OutputToken = this.createToken(this.m_InputToken.getPayload(), (Object)instA);
                        }
                    } else if (filteredData != null && filteredData.numInstances() > 0) {
                        this.m_OutputToken = this.createToken(this.m_InputToken.getPayload(), filteredData.instance(0));
                    }
                } else {
                    this.m_OutputToken = this.createToken(this.m_InputToken.getPayload(), filteredData);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter data: ", e);
            }
        }
        return result;
    }
}

