/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.Stoppable;
import adams.core.option.OptionHandler;
import adams.data.weka.InstancesViewCreator;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.transformer.AbstractArrayProvider;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instances;

public class WekaRandomSplit
extends AbstractArrayProvider
implements Randomizable,
InstancesViewCreator {
    private static final long serialVersionUID = -6447945986570354931L;
    protected boolean m_PreserveOrder;
    protected long m_Seed;
    protected double m_Percentage;
    protected boolean m_CreateView;
    protected RandomSplitGenerator m_Generator;
    protected transient RandomSplitGenerator m_ActualGenerator;

    public String globalInfo() {
        return "Splits a dataset into a training and test set according to a specified split percentage. Randomization can be suppressed using the 'preserve order' option.\nThe training set can be accessed in the container with 'Train' and the test set with 'Test'.\nDepending on the split generator in use, more than one container may be output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)1.0E-4, (Number)0.9999);
        this.m_OptionManager.add("create-view", "createView", (Object)false);
        this.m_OptionManager.add("generator", "generator", (Object)new DefaultRandomSplitGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_ActualGenerator = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (boolean)this.m_PreserveOrder, (String)"order preserved", (String)", ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)", as array")) != null) {
            result = result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected Class getItemClass() {
        return WekaTrainTestSetContainer.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the splits are output as array rather than one-by-one.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If set to true, then the order is preserved by suppressing randomization; overrides the value defined by the split generator scheme.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization; overrides the value defined by the split generator scheme.";
    }

    public void setPercentage(double value) {
        if (value > 0.0 && value < 1.0) {
            this.m_Percentage = value;
            this.reset();
        } else {
            this.getLogger().severe("Percentage must be between 0 and 1 (provided: " + value + ")!");
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage for the split (between 0 and 1); overrides the value defined by the split generator scheme.";
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, views of the dataset are created instead of actual copies; overrides the value defined by the split generator scheme.";
    }

    public void setGenerator(RandomSplitGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomSplitGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the split; the actor options take precedence over the scheme's ones.";
    }

    protected String doExecute() {
        String result = null;
        Instances inst = new Instances((Instances)this.m_InputToken.getPayload());
        this.m_Queue.clear();
        try {
            this.m_ActualGenerator = (RandomSplitGenerator)ObjectCopyHelper.copyObject((Object)this.m_Generator);
            this.m_ActualGenerator.setData(inst);
            this.m_ActualGenerator.setSeed(this.m_Seed);
            this.m_ActualGenerator.setPercentage(this.m_Percentage);
            this.m_ActualGenerator.setPreserveOrder(this.m_PreserveOrder);
            this.m_ActualGenerator.setUseViews(this.m_CreateView);
        }
        catch (Exception e) {
            this.m_ActualGenerator = null;
            result = this.handleException("Failed to generate split!", e);
        }
        if (result == null) {
            while (this.m_ActualGenerator.hasNext()) {
                this.m_Queue.add(this.m_ActualGenerator.next());
            }
        }
        this.m_ActualGenerator = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_ActualGenerator != null && this.m_ActualGenerator instanceof Stoppable) {
            ((Stoppable)this.m_ActualGenerator).stopExecution();
        }
        super.stopExecution();
    }
}

