/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.indexedsplitsrunsgenerator;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.MetaData;
import adams.flow.transformer.indexedsplitsrunsgenerator.AbstractIndexedSplitsRunsGenerator;
import adams.flow.transformer.indexedsplitsrunsgenerator.InstancesIndexedSplitsRunsGenerator;
import weka.core.Attribute;
import weka.core.Instances;

public abstract class AbstractInstancesIndexedSplitsRunsGenerator
extends AbstractIndexedSplitsRunsGenerator
implements InstancesIndexedSplitsRunsGenerator {
    private static final long serialVersionUID = -3421372018638798691L;
    protected boolean m_AddDatasetInformation;
    protected boolean m_AddAttributeInformation;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-dataset-information", "addDatasetInformation", (Object)false);
        this.m_OptionManager.add("add-attribute-information", "addAttributeInformation", (Object)false);
    }

    public void setAddDatasetInformation(boolean value) {
        this.m_AddDatasetInformation = value;
        this.reset();
    }

    public boolean getAddDatasetInformation() {
        return this.m_AddDatasetInformation;
    }

    public String addDatasetInformationTipText() {
        return "If enabled, dataset name and dimensions get added to the meta-data.";
    }

    public void setAddAttributeInformation(boolean value) {
        this.m_AddAttributeInformation = value;
        this.reset();
    }

    public boolean getAddAttributeInformation() {
        return this.m_AddAttributeInformation;
    }

    public String addAttributeInformationTipText() {
        return "If enabled, attribute names and types get added to the meta-data.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"addDatasetInformation", (boolean)this.m_AddDatasetInformation, (String)"dataset info", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"addAttributeInformation", (boolean)this.m_AddAttributeInformation, (String)"att. info", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected IndexedSplitsRuns postGenerate(Object data, IndexedSplitsRuns runs, MessageCollection errors) {
        if ((runs = super.postGenerate(data, runs, errors)) != null) {
            Instances inst = (Instances)data;
            MetaData meta = runs.getMetaData();
            if (this.m_AddDatasetInformation || this.m_AddAttributeInformation) {
                meta.put((Object)"dataset.num_attributes", (Object)inst.numAttributes());
            }
            if (this.m_AddDatasetInformation) {
                meta.put((Object)"dataset.name", (Object)inst.relationName());
                meta.put((Object)"dataset.num_instances", (Object)inst.numInstances());
            }
            if (this.m_AddAttributeInformation) {
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    meta.put((Object)("dataset.attribute." + i + ".name"), (Object)inst.attribute(i).name());
                    meta.put((Object)("dataset.attribute." + i + ".type"), (Object)Attribute.typeToStringShort((int)inst.attribute(i).type()));
                }
            }
        }
        return runs;
    }
}

