/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.core.classmanager.ClassManager;
import adams.gui.goe.AbstractEditorRegistration;
import adams.gui.goe.ColorEditor;
import adams.gui.goe.Editors;
import adams.gui.goe.FileEditor;
import adams.gui.goe.GenericObjectEditor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import weka.core.PluginManager;

public class WekaEditorsRegistration
extends AbstractEditorRegistration {
    private static final long serialVersionUID = -2908979337117222215L;
    public static final String PROPERTY_WEKAEDITORS = "adams.gui.wekaeditors";
    protected static boolean m_UseWekaEditors = Boolean.getBoolean("adams.gui.wekaeditors");
    protected static boolean m_Registered;
    protected static Set<Class> m_AlreadRegistered;

    protected boolean hasRegistered() {
        return m_Registered;
    }

    protected void registerEditors(Properties props) {
        for (Object key : props.keySet()) {
            try {
                Class cls;
                if (key.toString().endsWith("[]") || m_AlreadRegistered.contains(cls = ClassManager.getSingleton().forName("" + key))) continue;
                PropertyEditor editor = PropertyEditorManager.findEditor(cls);
                Class<GenericObjectEditor> newEditor = null;
                if (editor instanceof weka.gui.GenericObjectEditor) {
                    newEditor = GenericObjectEditor.class;
                } else if (editor instanceof weka.gui.FileEditor) {
                    newEditor = FileEditor.class;
                } else if (editor instanceof weka.gui.ColorEditor) {
                    newEditor = ColorEditor.class;
                }
                if (newEditor != null) {
                    Editors.registerCustomEditor((Class)cls, newEditor);
                    this.getLogger().info("Registering " + cls.getName() + ": " + editor.getClass().getName() + " -> " + newEditor.getName());
                }
                m_AlreadRegistered.add(cls);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to register editors: " + key, (Throwable)e);
            }
        }
    }

    protected void registerHierarchies(Properties props) {
        for (Object key : props.keySet()) {
            String superclass = "" + key;
            String[] classes = props.getProperty(superclass).replaceAll(" ", "").split(",");
            ArrayList<Class> classList = new ArrayList<Class>();
            for (String clsname : classes) {
                if (clsname.trim().isEmpty()) continue;
                try {
                    Class cls = ClassManager.getSingleton().forName(clsname);
                    classList.add(cls);
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().warning("Class not found: " + clsname);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to register class hierarchy: " + key, (Throwable)e);
                }
            }
            if (classList.size() <= 0) continue;
            try {
                ClassLister.getSingleton().addHierarchy(ClassManager.getSingleton().forName(superclass), classList.toArray(new Class[0]));
                this.getLogger().info("Registering class hierarchy: " + key);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to register class hierarchy: " + key, (Throwable)e);
            }
        }
    }

    protected void registerEditors(Map<String, Map<String, String>> hierarchies) {
        for (String superclass : hierarchies.keySet().toArray(new String[0])) {
            try {
                Class cls = ClassManager.getSingleton().forName(superclass);
                if (m_AlreadRegistered.contains(cls)) continue;
                PropertyEditor editor = PropertyEditorManager.findEditor(cls);
                Class<GenericObjectEditor> newEditor = null;
                if (editor instanceof weka.gui.GenericObjectEditor) {
                    newEditor = GenericObjectEditor.class;
                } else if (editor instanceof weka.gui.FileEditor) {
                    newEditor = FileEditor.class;
                } else if (editor instanceof weka.gui.ColorEditor) {
                    newEditor = ColorEditor.class;
                }
                if (newEditor != null) {
                    Editors.registerCustomEditor((Class)cls, newEditor);
                    this.getLogger().info("Registering " + cls.getName() + ": " + editor.getClass().getName() + " -> " + newEditor.getName());
                }
                m_AlreadRegistered.add(cls);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to register editors: " + superclass, (Throwable)e);
            }
        }
    }

    protected void registerHierarchies(Map<String, Map<String, String>> hierarchies) {
        for (String superclass : hierarchies.keySet().toArray(new String[0])) {
            Set<String> classes = hierarchies.get(superclass).keySet();
            ArrayList<Class> classList = new ArrayList<Class>();
            for (String clsname : classes) {
                if (clsname.trim().isEmpty()) continue;
                try {
                    Class cls = ClassManager.getSingleton().forName(clsname);
                    classList.add(cls);
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().warning("Class not found: " + clsname);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to register class hierarchy: " + superclass, (Throwable)e);
                }
            }
            if (classList.size() <= 0) continue;
            try {
                ClassLister.getSingleton().addHierarchy(ClassManager.getSingleton().forName(superclass), classList.toArray(new Class[0]));
                this.getLogger().info("Registering class hierarchy: " + superclass);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to register class hierarchy: " + superclass, (Throwable)e);
            }
        }
    }

    public static boolean useWekaEditors() {
        return m_UseWekaEditors;
    }

    protected boolean doRegister() {
        weka.gui.GenericObjectEditor.determineClasses();
        weka.gui.GenericObjectEditor.registerEditors();
        if (!WekaEditorsRegistration.useWekaEditors()) {
            this.registerEditors(AccessibleGenericObjectEditor.getProperties());
            this.registerEditors(AccessiblePluginManager.getPlugins());
        }
        this.registerHierarchies(AccessibleGenericObjectEditor.getProperties());
        this.registerHierarchies(AccessiblePluginManager.getPlugins());
        m_Registered = true;
        return true;
    }

    static {
        m_AlreadRegistered = new HashSet<Class>();
    }

    public static class AccessiblePluginManager
    extends PluginManager {
        public static Map<String, Map<String, String>> getPlugins() {
            return PLUGINS;
        }

        public static Map<String, Map<String, String>> getResources() {
            return RESOURCES;
        }

        public static Set<String> getDisabled() {
            return DISABLED;
        }
    }

    public static class AccessibleGenericObjectEditor
    extends weka.gui.GenericObjectEditor {
        public static Properties getProperties() {
            return EDITOR_PROPERTIES;
        }
    }
}

