/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.gui.core.Undo;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import java.io.Serializable;
import java.util.Date;
import weka.core.Instances;

public abstract class AbstractDataContainer
extends LoggingObject
implements DataContainer,
UndoListener {
    private static final long serialVersionUID = 6267905940957451551L;
    protected static int m_IDCounter;
    protected int m_ID = AbstractDataContainer.nextID();
    protected Instances m_Data = null;
    protected boolean m_Modified = false;
    protected transient Undo m_Undo = null;
    protected Date m_LastUpdated = new Date();

    public AbstractDataContainer() {
    }

    public AbstractDataContainer(Instances data) {
        this();
        this.m_Data = data;
        this.m_Modified = false;
    }

    @Override
    public void setData(Instances value) {
        if (this.m_Data != null) {
            this.addUndoPoint("updated data");
            this.setModified(true);
        }
        this.m_Data = value;
        this.m_LastUpdated = new Date();
    }

    @Override
    public Instances getData() {
        return this.m_Data;
    }

    @Override
    public int getID() {
        return this.m_ID;
    }

    @Override
    public boolean isModified() {
        return this.m_Modified;
    }

    @Override
    public void setModified(boolean value) {
        this.m_Modified = value;
        this.m_LastUpdated = new Date();
    }

    protected abstract String doReload();

    @Override
    public String reload() {
        String result = null;
        if (this.canReload() && (result = this.doReload()) == null) {
            this.setModified(false);
            if (this.isUndoSupported()) {
                this.getUndo().clear();
            }
        }
        return result;
    }

    public void setUndo(Undo value) {
        if (this.m_Undo != null) {
            this.m_Undo.removeUndoListener((UndoListener)this);
        }
        this.m_Undo = value;
        if (this.m_Undo != null) {
            this.m_Undo.addUndoListener((UndoListener)this);
        }
    }

    public synchronized Undo getUndo() {
        if (this.m_Undo == null) {
            this.m_Undo = new Undo(Serializable[].class, true);
            this.m_Undo.addUndoListener((UndoListener)this);
        }
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.getUndo().isEnabled();
    }

    public void undoOccurred(UndoEvent e) {
        if (e.getType() == UndoEvent.UndoType.UNDO) {
            this.applyUndoData((Serializable[])e.getUndoPoint().getData());
        }
    }

    public void undo() {
        if (!this.isUndoSupported() || !this.getUndo().canUndo()) {
            return;
        }
        this.getUndo().addRedo((Object)this.getUndoData(), this.getUndo().peekUndoComment());
        Undo.UndoPoint point = this.getUndo().undo();
        this.applyUndoData((Serializable[])point.getData());
    }

    public void redo() {
        if (!this.isUndoSupported() || !this.getUndo().canUndo()) {
            return;
        }
        this.getUndo().addUndo((Object)this.getUndoData(), this.getUndo().peekRedoComment(), true);
        Undo.UndoPoint point = this.getUndo().redo();
        this.applyUndoData((Serializable[])point.getData());
    }

    public void addUndoPoint(String comment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.getUndo().addUndo((Object)this.getUndoData(), comment);
        }
    }

    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified)};
    }

    protected void applyUndoData(Serializable[] data) {
        this.m_LastUpdated = new Date();
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
    }

    @Override
    public Date lastUpdated() {
        return this.m_LastUpdated;
    }

    protected String handleException(String msg, Throwable t) {
        return LoggingHelper.handleException((LoggingSupporter)this, (String)msg, (Throwable)t);
    }

    @Override
    public int compareTo(DataContainer o) {
        int result = this.getSource().compareTo(o.getSource());
        if (result == 0) {
            result = Integer.compare(this.getID(), o.getID());
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataContainer && this.getID() == ((DataContainer)obj).getID();
    }

    public String toString() {
        return this.getData().relationName() + " [" + this.getSource() + "]";
    }

    public void cleanUp() {
        this.m_Data = null;
        if (this.m_Undo != null) {
            this.m_Undo.cleanUp();
        }
    }

    protected static synchronized int nextID() {
        return ++m_IDCounter;
    }
}

