/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.core.Utils;
import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Random;

public class Randomize
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Randomize() {
        this.setName("Randomize");
        this.setIcon("randomize.gif");
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Randomizing dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        String seedStr = GUIHelper.showInputDialog((Component)((Object)this.getOwner()), (String)"Please enter seed value for randomization: ", (String)"1");
        if (seedStr == null) {
            this.logMessage("Randomization cancelled!");
            return;
        }
        if (!Utils.isLong((String)seedStr)) {
            this.logMessage("Seed not integer, randomization cancelled!");
            return;
        }
        long seed = Long.parseLong(seedStr);
        cont.addUndoPoint("randomizing with seed " + seed);
        cont.getData().randomize(new Random(seed));
        cont.setModified(true);
        this.logMessage("Successfully randomized " + cont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getSelectedRows()[0]));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

