/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MonitoringDataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.event.ActionEvent;

public class Revert
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Revert() {
        this.setName("Revert");
        this.setIcon("revert.png");
        this.setAsynchronous(true);
    }

    protected boolean hasChanged(DataContainer cont) {
        boolean result = cont.isModified();
        if (!result && cont instanceof MonitoringDataContainer) {
            result = ((MonitoringDataContainer)cont).hasSourceChanged();
        }
        return result;
    }

    protected boolean canRevert() {
        boolean result = false;
        for (DataContainer cont : this.getSelectedData()) {
            if (!this.hasChanged(cont) || !cont.canReload()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void doActionPerformed(ActionEvent e) {
        for (DataContainer cont : this.getSelectedData()) {
            if (!this.hasChanged(cont) || !cont.canReload()) continue;
            this.logMessage("Reverting dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
            String msg = cont.reload();
            if (msg == null) {
                this.getOwner().getOwner().updateClassAttribute(cont.getData());
                this.logMessage("Successfully reverted " + cont.getID() + "!");
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getData().indexOf(cont)));
                continue;
            }
            this.logMessage("Failed to revert:\n" + msg);
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() > 0 && this.canRevert());
    }
}

