/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.FileContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import weka.core.converters.AbstractFileSaver;

public class Save
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;
    protected WekaFileChooser m_FileChooser;

    public Save() {
        this.setName("Save");
        this.setIcon("save.gif");
        this.setAsynchronous(true);
    }

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new WekaFileChooser();
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer[] conts = this.getSelectedData();
        final int[] rows = this.getSelectedRows();
        for (int i = 0; i < conts.length; ++i) {
            final int index = i;
            final DataContainer data = conts[i];
            PlaceholderFile suggested = data instanceof FileContainer ? new PlaceholderFile(data.getSource()) : new PlaceholderFile(this.m_FileChooser.getCurrentDirectory().getAbsolutePath() + File.separator + FileUtils.createFilename((String)data.getData().relationName(), (String)"_"));
            this.m_FileChooser.setDialogTitle("Saving " + (i + 1) + "/" + rows.length + ": " + data.getData().relationName());
            this.m_FileChooser.setCurrentDirectory(suggested.getParentFile());
            this.m_FileChooser.setSelectedFile((File)suggested);
            int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this.getOwner()));
            if (retVal != 0) break;
            final File file = this.m_FileChooser.getSelectedFile();
            this.getOwner().startExecution(new InvestigatorTabJob(this.getOwner(), this.m_FileChooser.getDialogTitle()){

                @Override
                protected void doRun() {
                    try {
                        if (file.exists() && !file.delete()) {
                            Save.this.logMessage("Failed to delete existing file: " + file);
                        }
                        AbstractFileSaver saver = (AbstractFileSaver)Save.this.m_FileChooser.getWriter();
                        saver.setFile(file);
                        saver.setInstances(data.getData());
                        saver.writeBatch();
                        Save.this.showStatus("Saved " + data.getID() + "/" + data.getSource() + " to " + file);
                        FileContainer cont = new FileContainer(Save.this.m_FileChooser.getReaderForFile(file), file, data.getData());
                        Save.this.getData().set(rows[index], cont);
                        String msg = this.getOwner().getOwner().addRecentFile(file, null);
                        if (msg != null) {
                            Save.this.showStatus(msg);
                        }
                        Save.this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, rows[index]));
                    }
                    catch (Exception ex) {
                        Save.this.logError("Failed to save: " + file + "\n", ex, "Save");
                    }
                }
            });
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

