/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.data.image.BufferedImageSupporter;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.tools.wekainvestigator.output.AbstractOutputPanelWithPopupMenu;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;

public class ComponentContentPanel
extends AbstractOutputPanelWithPopupMenu<JComponentWriterFileChooser>
implements BufferedImageSupporter {
    private static final long serialVersionUID = 8183731075946484533L;
    protected JComponent m_Component;

    public ComponentContentPanel(JComponent comp, boolean useScrollPane) {
        this.m_Component = comp;
        if (useScrollPane) {
            this.getContentPanel().add((Component)new BaseScrollPane((Component)this.m_Component), (Object)"Center");
        } else {
            this.getContentPanel().add((Component)this.m_Component, (Object)"Center");
        }
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    @Override
    protected JComponentWriterFileChooser createFileChooser() {
        return new JComponentWriterFileChooser();
    }

    @Override
    protected String save(File file) {
        String result = null;
        JComponentWriter writer = ((JComponentWriterFileChooser)this.getFileChooser()).getWriter();
        writer.setComponent(this.m_Component);
        writer.setFile(new PlaceholderFile(file));
        try {
            writer.toOutput();
        }
        catch (Exception e) {
            result = LoggingHelper.handleException(null, (String)("Failed to save content to: " + file), (Throwable)e);
        }
        return result;
    }

    public BufferedImage toBufferedImage() {
        BufferedImage result = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics g = result.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        return result;
    }

    @Override
    public boolean canCopyToClipboard() {
        return true;
    }

    @Override
    public void copyToClipboard() {
        ClipboardHelper.copyToClipboard((BufferedImage)this.toBufferedImage());
    }
}

