/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BaseSplitButton;
import adams.gui.core.BaseTextField;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabRunnableJob;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithEditableDataTable;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.AttributeSelectionPanel;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.InstancesSummaryPanel;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.MultiAttributeSummaryPanel;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.MultiAttributeVisualizationPanel;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.Remove;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class PreprocessTab
extends AbstractInvestigatorTabWithEditableDataTable {
    private static final long serialVersionUID = -94945456385486233L;
    public static final String KEY_FILTER = "filter";
    public static final String KEY_BATCHFILTER = "batchfilter";
    public static final String KEY_KEEPNAME = "keepname";
    public static final String KEY_REPLACE = "replace";
    public static final String KEY_SERIALIZE = "serialize";
    public static final String KEY_SERIALIZE_FILE = "serialize-file";
    protected GenericObjectEditorPanel m_PanelGOE;
    protected JPanel m_PanelTop;
    protected JPanel m_PanelMain;
    protected BaseCheckBox m_CheckBoxReplace;
    protected BaseCheckBox m_CheckBoxBatchFilter;
    protected BaseCheckBox m_CheckBoxKeepName;
    protected BaseCheckBox m_CheckBoxSerialize;
    protected FileChooserPanel m_FileSerialize;
    protected BaseButton m_ButtonStart;
    protected BaseButton m_ButtonStop;
    protected InstancesSummaryPanel m_PanelInstSummary;
    protected AttributeSelectionPanel m_PanelAttSelection;
    protected MultiAttributeSummaryPanel m_PanelAttSummary;
    protected MultiAttributeVisualizationPanel m_PanelAttVisualization;
    protected BaseTextField m_TextSelectedAttributes;
    protected BaseFlatButton m_ButtonSelectedAttributes;
    protected BaseSplitButton m_ButtonSelectedAttributesAction;
    protected Thread m_Worker;
    protected Filter m_CurrentFilter;
    protected List<AbstractSelectedAttributesAction> m_Actions;
    protected int m_MaxAttributesToVisualize;
    protected int[] m_LastAttributesToVisualize;

    @Override
    protected void initialize() {
        Class[] classes;
        super.initialize();
        this.m_Worker = null;
        this.m_Actions = new ArrayList<AbstractSelectedAttributesAction>();
        for (Class cls : classes = AbstractSelectedAttributesAction.getActions()) {
            try {
                AbstractSelectedAttributesAction action = (AbstractSelectedAttributesAction)((Object)cls.newInstance());
                action.setOwner(this);
                this.m_Actions.add(action);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, "Failed to instantiate action: " + cls.getName(), (Throwable)e);
            }
        }
        Properties props = InvestigatorPanel.getProperties();
        this.m_MaxAttributesToVisualize = props.getInteger("", Integer.valueOf(5));
        this.m_LastAttributesToVisualize = new int[0];
    }

    @Override
    protected void initGUI() {
        AllFilter filter;
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_PanelTop = new JPanel(new BorderLayout());
        this.m_PanelTop.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.m_PanelData.add((Component)this.m_PanelTop, "North");
        try {
            filter = (Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)InvestigatorPanel.getProperties().getProperty("Preprocess.Filter", AllFilter.class.getName()));
        }
        catch (Exception e2) {
            filter = new AllFilter();
        }
        this.m_PanelGOE = new GenericObjectEditorPanel(Filter.class, (Object)filter, true);
        this.m_PanelGOE.moveChooseButton(true);
        this.m_PanelGOE.addChangeListener(e -> this.updateButtons());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.m_PanelGOE, "Center");
        this.m_PanelTop.add((Component)panel, "Center");
        panel = new JPanel(new FlowLayout(0));
        this.m_PanelTop.add((Component)panel, "South");
        this.m_ButtonStart = new BaseButton("Start");
        this.m_ButtonStart.setEnabled(false);
        this.m_ButtonStart.addActionListener(e -> this.startExecution());
        panel.add((Component)this.m_ButtonStart);
        this.m_ButtonStop = new BaseButton("Stop");
        this.m_ButtonStop.setEnabled(false);
        this.m_ButtonStart.addActionListener(e -> this.stopExecution());
        panel.add((Component)this.m_ButtonStop);
        this.m_CheckBoxReplace = new BaseCheckBox("Replace datasets");
        this.m_CheckBoxReplace.setSelected(props.getBoolean("Preprocess.ReplaceDatasets", Boolean.valueOf(true)).booleanValue());
        panel.add((Component)this.m_CheckBoxReplace);
        this.m_CheckBoxKeepName = new BaseCheckBox("Keep name");
        this.m_CheckBoxKeepName.setSelected(props.getBoolean("Preprocess.KeepName", Boolean.valueOf(true)).booleanValue());
        panel.add((Component)this.m_CheckBoxKeepName);
        this.m_CheckBoxBatchFilter = new BaseCheckBox("Batch filter");
        this.m_CheckBoxBatchFilter.setSelected(props.getBoolean("Preprocess.BatchFilter", Boolean.valueOf(false)).booleanValue());
        panel.add((Component)this.m_CheckBoxBatchFilter);
        this.m_CheckBoxSerialize = new BaseCheckBox("Serialize");
        this.m_CheckBoxSerialize.setSelected(props.getBoolean("Preprocess.Serialize", Boolean.valueOf(false)).booleanValue());
        panel.add((Component)this.m_CheckBoxSerialize);
        this.m_FileSerialize = new FileChooserPanel(props.getPath("Preprocess.SerializeFile", "."));
        this.m_FileSerialize.setTextColumns(5);
        panel.add((Component)this.m_FileSerialize);
        this.m_PanelMain = new JPanel(new GridLayout(1, 2));
        this.m_PanelMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelData.add((Component)this.m_PanelMain, "Center");
        panel = new JPanel(new BorderLayout());
        this.m_PanelMain.add(panel);
        this.m_PanelInstSummary = new InstancesSummaryPanel();
        this.m_PanelInstSummary.setBorder(BorderFactory.createTitledBorder("Dataset summary"));
        panel.add((Component)this.m_PanelInstSummary, "North");
        JPanel panelAtts = new JPanel(new BorderLayout());
        panel.add((Component)panelAtts, "South");
        this.m_TextSelectedAttributes = new BaseTextField(15);
        this.m_TextSelectedAttributes.setEditable(false);
        this.m_ButtonSelectedAttributes = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonSelectedAttributes.setSize(this.m_TextSelectedAttributes.getHeight(), this.m_TextSelectedAttributes.getHeight());
        this.m_ButtonSelectedAttributes.addActionListener(e -> ClipboardHelper.copyToClipboard((String)this.m_TextSelectedAttributes.getText()));
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add((Component)this.m_TextSelectedAttributes);
        panel2.add((Component)this.m_ButtonSelectedAttributes);
        panelAtts.add((Component)panel2, "West");
        panel2 = new JPanel(new FlowLayout(2));
        this.m_ButtonSelectedAttributesAction = new BaseSplitButton();
        this.m_ButtonSelectedAttributesAction.setText("Attribute action");
        this.m_ButtonSelectedAttributesAction.setAlwaysDropdown(false);
        this.m_ButtonSelectedAttributesAction.setButtonEnabled(true);
        this.m_ButtonSelectedAttributesAction.addChangeListener(e -> {
            for (AbstractSelectedAttributesAction action : this.m_Actions) {
                action.update();
            }
        });
        for (AbstractSelectedAttributesAction action : this.m_Actions) {
            if (action instanceof Remove) {
                this.m_ButtonSelectedAttributesAction.setAction((Action)((Object)action));
                continue;
            }
            this.m_ButtonSelectedAttributesAction.add((Action)((Object)action));
        }
        panel2.add((Component)this.m_ButtonSelectedAttributesAction);
        panelAtts.add((Component)panel2, "East");
        this.m_PanelAttSelection = new AttributeSelectionPanel();
        this.m_PanelAttSelection.setBorder(BorderFactory.createTitledBorder("Attributes"));
        this.m_PanelAttSelection.addSelectionListener(e -> {
            boolean changed;
            this.updateAttributeSelection();
            for (AbstractSelectedAttributesAction action : this.m_Actions) {
                action.update();
            }
            int[] indices = this.m_PanelAttSelection.getSelectedRows();
            if (indices.length > this.m_MaxAttributesToVisualize) {
                int[] newIndices = new int[this.m_MaxAttributesToVisualize];
                System.arraycopy(indices, 0, newIndices, 0, this.m_MaxAttributesToVisualize);
                indices = newIndices;
            }
            boolean bl = changed = indices.length != this.m_LastAttributesToVisualize.length;
            if (!changed) {
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] == this.m_LastAttributesToVisualize[i]) continue;
                    changed = true;
                    break;
                }
            }
            if (!changed) {
                return;
            }
            this.m_PanelAttSummary.setAttributes(indices);
            this.m_PanelAttVisualization.setAttributes(indices);
            this.m_LastAttributesToVisualize = indices;
        });
        panel.add((Component)((Object)this.m_PanelAttSelection), "Center");
        panel = new JPanel(new GridLayout(2, 1));
        this.m_PanelMain.add(panel);
        this.m_PanelAttSummary = new MultiAttributeSummaryPanel();
        this.m_PanelAttSummary.setBorder(BorderFactory.createTitledBorder("Attribute summary"));
        panel.add((Component)((Object)this.m_PanelAttSummary));
        this.m_PanelAttVisualization = new MultiAttributeVisualizationPanel();
        panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createTitledBorder("Attribute visualization"));
        panel2.add((Component)((Object)this.m_PanelAttVisualization));
        panel.add(panel2);
        this.m_SplitPane.setBottomComponentHidden(false);
        this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight);
    }

    protected void updateAttributeSelection() {
        int[] indices = this.m_PanelAttSelection.getSelectedAttributes();
        if (indices == null) {
            indices = new int[]{};
        }
        if (indices.length == 0) {
            this.m_TextSelectedAttributes.setText("");
        } else {
            Range range = new Range();
            range.setIndices(indices);
            this.m_TextSelectedAttributes.setText(range.getRange());
        }
        this.m_ButtonSelectedAttributes.setEnabled(indices.length > 0);
    }

    protected String isCompatible(int[] indices) {
        DataContainer first = this.getData().get(indices[0]);
        MessageCollection errors = new MessageCollection();
        for (int i = 1; i < indices.length; ++i) {
            DataContainer other = this.getData().get(indices[i]);
            String msg = first.getData().equalHeadersMsg(other.getData());
            if (msg == null) continue;
            errors.add("Dataset " + other.getID() + " is not compatible:\n" + msg);
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toString();
    }

    protected void startExecution() {
        String msg;
        if (!this.canStartExecution()) {
            return;
        }
        final InvestigatorPanel owner = this.getOwner();
        this.m_CurrentFilter = (Filter)this.m_PanelGOE.getCurrent();
        final boolean batch = this.m_CheckBoxBatchFilter.isSelected();
        final boolean replace = this.m_CheckBoxReplace.isSelected();
        final boolean keep = this.m_CheckBoxKeepName.isSelected();
        final File serialize = this.m_CheckBoxSerialize.isSelected() && !((File)this.m_FileSerialize.getCurrent()).isDirectory() ? (File)this.m_FileSerialize.getCurrent() : null;
        final int[] indices = this.getSelectedRows();
        if (batch && indices.length > 1 && (msg = this.isCompatible(indices)) != null) {
            this.logError("The datasets are not compatible and cannot be batch-filtered:\n" + msg, "Batch-filtering");
            return;
        }
        this.startExecution(new InvestigatorTabJob(this, "Filtering"){

            @Override
            protected void doRun() {
                for (int i = 0; i < indices.length; ++i) {
                    DataContainer cont = PreprocessTab.this.getData().get(indices[i]);
                    PreprocessTab.this.logMessage("Starting filtering " + (i + 1) + "/" + indices.length + " '" + cont.getID() + "/" + cont.getData().relationName() + "' using " + OptionUtils.getCommandLine((Object)PreprocessTab.this.m_CurrentFilter));
                    try {
                        String oldName = cont.getData().relationName();
                        if (batch && i == 0 || !batch) {
                            PreprocessTab.this.m_CurrentFilter.setInputFormat(cont.getData());
                        }
                        Instances filtered = Filter.useFilter((Instances)cont.getData(), (Filter)PreprocessTab.this.m_CurrentFilter);
                        if (keep) {
                            filtered.setRelationName(oldName);
                        }
                        PreprocessTab.this.logMessage("Finished filtering " + (i + 1) + "/" + indices.length + " '" + cont.getID() + "/" + cont.getData().relationName() + "' using " + OptionUtils.getCommandLine((Object)PreprocessTab.this.m_CurrentFilter));
                        if (replace) {
                            cont.setData(filtered);
                            PreprocessTab.this.fireDataChange(new WekaInvestigatorDataEvent(owner, 4, indices[i]));
                        } else {
                            cont = new MemoryContainer(filtered);
                            PreprocessTab.this.getData().add(cont);
                            PreprocessTab.this.fireDataChange(new WekaInvestigatorDataEvent(owner, 2, PreprocessTab.this.getData().size() - 1));
                        }
                        if (i != 0 || serialize == null) continue;
                        SerializationHelper.write((String)serialize.getAbsolutePath(), (Object)PreprocessTab.this.m_CurrentFilter);
                        PreprocessTab.this.logMessage("Serialized filter to: " + serialize);
                        continue;
                    }
                    catch (Exception e) {
                        PreprocessTab.this.logError("Failed to filter data" + (i + 1) + "/" + indices.length, e, "Filter");
                        break;
                    }
                }
            }
        });
    }

    @Override
    protected void postStartExecution(InvestigatorTabJob job) {
        super.postStartExecution(job);
        this.updateButtons();
    }

    @Override
    protected void postStopExecution() {
        super.postStopExecution();
        this.logMessage("Stopped filtering using " + OptionUtils.getCommandLine((Object)this.m_CurrentFilter));
        this.updateButtons();
    }

    @Override
    protected void postExecutionFinished() {
        super.postExecutionFinished();
        this.updateButtons();
    }

    public synchronized boolean submitJob(Runnable run) {
        return this.canStartExecution() && this.startExecution(new InvestigatorTabRunnableJob((AbstractInvestigatorTab)this, run));
    }

    protected String canFilter() {
        if (this.isBusy()) {
            return "Currently busy...";
        }
        if (this.getSelectedRows().length == 0) {
            return "No dataset selected!";
        }
        return null;
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        String msg = this.canFilter();
        this.m_ButtonStart.setEnabled(msg == null);
        this.m_ButtonStart.setToolTipText(msg);
        this.m_ButtonStop.setEnabled(this.isBusy());
        this.m_ButtonSelectedAttributesAction.setEnabled(!this.isBusy() && this.getSelectedRows().length == 1);
        this.m_ButtonSelectedAttributes.setEnabled(this.m_TextSelectedAttributes.getText().length() > 0);
        this.updateAttributeSelection();
    }

    @Override
    public String getTitle() {
        return "Preprocess";
    }

    @Override
    public String getTabIcon() {
        return "filter.png";
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 2;
    }

    @Override
    public void fireDataChange(WekaInvestigatorDataEvent e) {
        super.fireDataChange(e);
        this.displayData();
    }

    @Override
    protected void dataTableSelectionChanged() {
        super.dataTableSelectionChanged();
        this.displayData();
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        if (e.getType() == 2 && e.getRows().length == 1) {
            this.m_Table.setSelectedRow(e.getRows()[0]);
        }
        this.displayData();
    }

    protected void displayData() {
        if (this.getData().size() > 0 && this.getSelectedRows().length == 1) {
            DataContainer cont = this.getData().get(this.getSelectedRows()[0]);
            this.m_PanelInstSummary.setInstances(cont.getData());
            this.m_PanelAttSelection.setInstances(cont.getData());
            this.m_PanelAttSummary.setInstances(cont.getData());
            this.m_PanelAttVisualization.setInstances(cont.getData());
            this.m_ButtonSelectedAttributesAction.setEnabled(true);
        } else {
            this.m_PanelInstSummary.setInstances(null);
            this.m_PanelAttSelection.setInstances(null);
            this.m_PanelAttSummary.setInstances(null);
            this.m_PanelAttVisualization.setInstances(null);
            this.m_ButtonSelectedAttributesAction.setEnabled(false);
        }
        this.repaint();
    }

    public AttributeSelectionPanel getAttributeSelectionPanel() {
        return this.m_PanelAttSelection;
    }

    public BaseCheckBox getCheckBoxReplace() {
        return this.m_CheckBoxReplace;
    }

    public BaseCheckBox getCheckBoxBatchFilter() {
        return this.m_CheckBoxBatchFilter;
    }

    public BaseCheckBox getCheckBoxKeepName() {
        return this.m_CheckBoxKeepName;
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FILTER, OptionUtils.getCommandLine((Object)this.m_PanelGOE.getCurrent()));
            result.put(KEY_BATCHFILTER, this.m_CheckBoxBatchFilter.isSelected());
            result.put(KEY_KEEPNAME, this.m_CheckBoxKeepName.isSelected());
            result.put(KEY_REPLACE, this.m_CheckBoxReplace.isSelected());
            result.put(KEY_SERIALIZE, this.m_CheckBoxSerialize.isSelected());
            result.put(KEY_SERIALIZE_FILE, ((File)this.m_FileSerialize.getCurrent()).getAbsolutePath());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_FILTER)) {
            try {
                this.m_CurrentFilter = (Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)((String)data.get(KEY_FILTER)));
                this.m_PanelGOE.setCurrent((Object)this.m_CurrentFilter);
            }
            catch (Exception e) {
                errors.add("Failed to restore filter: " + data.get(KEY_FILTER), (Throwable)e);
            }
        }
        if (data.containsKey(KEY_BATCHFILTER)) {
            this.m_CheckBoxBatchFilter.setSelected(((Boolean)data.get(KEY_BATCHFILTER)).booleanValue());
        }
        if (data.containsKey(KEY_KEEPNAME)) {
            this.m_CheckBoxKeepName.setSelected(((Boolean)data.get(KEY_KEEPNAME)).booleanValue());
        }
        if (data.containsKey(KEY_REPLACE)) {
            this.m_CheckBoxReplace.setSelected(((Boolean)data.get(KEY_REPLACE)).booleanValue());
        }
        if (data.containsKey(KEY_SERIALIZE)) {
            this.m_CheckBoxSerialize.setSelected(((Boolean)data.get(KEY_SERIALIZE)).booleanValue());
        }
        if (data.containsKey(KEY_SERIALIZE_FILE)) {
            this.m_FileSerialize.setCurrent((File)new PlaceholderFile((String)data.get(KEY_SERIALIZE_FILE)));
        }
    }
}

