/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.attseltab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.AttributeSelectionTab;
import adams.gui.tools.wekainvestigator.tab.attseltab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.attseltab.evaluation.AbstractAttributeSelectionEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.core.Capabilities;
import weka.core.Instances;

public class Train
extends AbstractAttributeSelectionEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;

    public String globalInfo() {
        return "Performs attribute selection on the selected dataset.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
    }

    @Override
    public String getName() {
        return "Train";
    }

    @Override
    public String canEvaluate(ASEvaluation evaluator, ASSearch search) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        Instances data = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = evaluator.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Evaluator cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Evaluator cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(ASEvaluation evaluator, ASSearch search) throws Exception {
        Instances data = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(evaluator, search, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(ASEvaluation evaluator, ASSearch search, ResultItem item) throws Exception {
        String msg = this.canEvaluate(evaluator, search);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot perform attribute selection!\n" + msg);
        }
        DataContainer dataCont = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        ASEvaluation eval = (ASEvaluation)ObjectCopyHelper.copyObject((Object)evaluator);
        ASSearch srch = (ASSearch)ObjectCopyHelper.copyObject((Object)search);
        MetaData runInfo = new MetaData();
        runInfo.add("Evaluator", (Object)OptionUtils.getCommandLine((Object)evaluator));
        runInfo.add("Search", (Object)OptionUtils.getCommandLine((Object)search));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        if (data.classIndex() > -1) {
            runInfo.add("Class attribute", (Object)data.classAttribute().name());
        }
        AttributeSelection attsel = new AttributeSelection();
        attsel.setSearch(srch);
        attsel.setEvaluator(eval);
        attsel.SelectAttributes(data);
        item.update(attsel, data, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((AttributeSelectionTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((AttributeSelectionTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((AttributeSelectionTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((AttributeSelectionTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
    }
}

