/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab;

import adams.core.DateUtils;
import adams.core.Shortening;
import adams.data.spreadsheet.MetaData;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.wekainvestigator.output.AbstractNestableResultItem;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class ResultItem
extends AbstractNestableResultItem {
    private static final long serialVersionUID = -3409493446200539772L;
    protected Evaluation m_Evaluation;
    protected Evaluation[] m_FoldEvaluations;
    protected Classifier m_Template;
    protected Classifier m_Model;
    protected Classifier[] m_FoldModels;
    protected MetaData m_RunInformation;
    protected int[] m_OriginalIndices;
    protected SpreadSheet m_AdditionalAttributes;

    public ResultItem(Classifier template, Instances header) {
        super(header);
        if (template == null) {
            throw new IllegalArgumentException("Template classifier cannot be null!");
        }
        this.m_Template = template;
    }

    @Override
    protected String createName() {
        String result = DateUtils.getTimeFormatterMsecs().format(this.m_Timestamp) + " - " + this.m_Template.getClass().getSimpleName();
        if (this.m_NameSuffix != null) {
            result = result + " - " + this.m_NameSuffix;
        }
        if (this.hasHeader()) {
            result = result + " - " + this.m_Header.classAttribute().name() + " of " + Shortening.shortenEnd((String)this.m_Header.relationName(), (int)30);
        }
        return result;
    }

    public void update(Evaluation evaluation, Classifier model) {
        this.update(evaluation, model, null);
    }

    public void update(Evaluation evaluation, Classifier model, MetaData runInfo) {
        this.update(evaluation, model, runInfo, null, null);
    }

    public void update(Evaluation evaluation, Classifier model, MetaData runInfo, int[] original, SpreadSheet additional) {
        this.update(evaluation, null, model, null, runInfo, original, additional);
    }

    public void update(Evaluation evaluation, Evaluation[] foldEvaluations, Classifier model, Classifier[] foldModels, MetaData runInfo, int[] original, SpreadSheet additional) {
        this.m_Evaluation = evaluation;
        this.m_FoldEvaluations = foldEvaluations;
        this.m_FoldModels = foldModels;
        this.m_Model = model;
        this.m_RunInformation = runInfo;
        this.m_OriginalIndices = original;
        this.m_AdditionalAttributes = additional;
        this.invalidateName();
    }

    public boolean hasEvaluation() {
        return this.m_Evaluation != null;
    }

    public Evaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public boolean hasFoldEvaluations() {
        return this.m_FoldEvaluations != null;
    }

    public Evaluation[] getFoldEvaluations() {
        return this.m_FoldEvaluations;
    }

    public void setTemplate(Classifier value) {
        this.m_Template = value;
    }

    public Classifier getTemplate() {
        return this.m_Template;
    }

    public boolean hasModel() {
        return this.m_Model != null;
    }

    public void setModel(Classifier value) {
        this.m_Model = value;
    }

    public Classifier getModel() {
        return this.m_Model;
    }

    public boolean hasFoldModels() {
        return this.m_FoldModels != null;
    }

    public Classifier[] getFoldModels() {
        return this.m_FoldModels;
    }

    public boolean hasRunInformation() {
        return this.m_RunInformation != null;
    }

    public MetaData getRunInformation() {
        return this.m_RunInformation;
    }

    public boolean hasOriginalIndices() {
        return this.m_OriginalIndices != null;
    }

    public int[] getOriginalIndices() {
        return this.m_OriginalIndices;
    }

    public boolean hasAdditionalAttributes() {
        return this.m_AdditionalAttributes != null;
    }

    public void setAdditionalAttributes(SpreadSheet value) {
        this.m_AdditionalAttributes = value;
    }

    public SpreadSheet getAdditionalAttributes() {
        return this.m_AdditionalAttributes;
    }

    @Override
    public String toString() {
        String result = this.getName();
        result = result + ", evaluation=" + this.hasEvaluation() + ", template=" + this.getTemplate().getClass().getName() + ", model=" + this.hasModel() + ", header=" + this.hasHeader() + ", runInfo=" + this.hasRunInformation();
        return result;
    }
}

