/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.MetaData;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import adams.data.spreadsheet.SpreadSheetView;
import adams.flow.core.Token;
import adams.flow.transformer.WekaSpreadSheetToPredictions;
import adams.gui.chooser.SpreadSheetFileChooserPanel;
import adams.gui.core.IndexTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RangeTextField;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import java.util.Set;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;

public class FromPredictions
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_FILE = "file";
    public static final String KEY_READER = "reader";
    public static final String KEY_ACTUAL = "actual";
    public static final String KEY_PREDICTED = "predicted";
    public static final String KEY_WEIGHT = "weight";
    public static final String KEY_CLASSDISTRIBUTION = "class distribution";
    public static final String KEY_ADDITIONAL = "additional";
    protected ParameterPanel m_PanelParameters;
    protected SpreadSheetFileChooserPanel m_PanelFile;
    protected IndexTextField m_TextActual;
    protected IndexTextField m_TextPredicted;
    protected IndexTextField m_TextWeight;
    protected RangeTextField m_TextClassDistribution;
    protected RangeTextField m_TextAdditional;
    protected weka.classifiers.functions.FromPredictions m_Model;

    public String globalInfo() {
        return "Loads predictions from a spreadsheet for evaluation.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Model = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_PanelFile = new SpreadSheetFileChooserPanel();
        this.m_PanelFile.addChangeListener(e -> {
            this.m_Model = null;
            ((ClassifyTab)this.getOwner()).updateButtons();
        });
        this.m_PanelParameters.addParameter("Predictions", (Component)this.m_PanelFile);
        this.m_TextActual = new IndexTextField("1");
        this.m_PanelParameters.addParameter("Actual", (Component)this.m_TextActual);
        this.m_TextPredicted = new IndexTextField("2");
        this.m_PanelParameters.addParameter("Predicted", (Component)this.m_TextPredicted);
        this.m_TextWeight = new IndexTextField("");
        this.m_PanelParameters.addParameter("Weight", (Component)this.m_TextWeight);
        this.m_TextClassDistribution = new RangeTextField("");
        this.m_PanelParameters.addParameter("Class distribution", (Component)this.m_TextClassDistribution);
        this.m_TextAdditional = new RangeTextField("first-last");
        this.m_PanelParameters.addParameter("Additional", (Component)this.m_TextAdditional);
    }

    @Override
    public String getName() {
        return "From predictions";
    }

    protected String createFakeModel() {
        this.m_Model = null;
        File file = (File)this.m_PanelFile.getCurrent();
        if (file.isDirectory()) {
            return "File points to a directory: " + file;
        }
        if (!file.exists()) {
            return "File does not exist: " + file;
        }
        weka.classifiers.functions.FromPredictions model = new weka.classifiers.functions.FromPredictions();
        model.setPredictionsFile(new PlaceholderFile((File)this.m_PanelFile.getCurrent()));
        model.setReader((SpreadSheetReader)ObjectCopyHelper.copyObject((Object)this.m_PanelFile.getReader()));
        model.setActual(new SpreadSheetColumnIndex(this.m_TextActual.getText()));
        model.setPredicted(new SpreadSheetColumnIndex(this.m_TextPredicted.getText()));
        model.setWeight(new SpreadSheetColumnIndex(this.m_TextWeight.getText()));
        model.setClassDistribution(new SpreadSheetUnorderedColumnRange(this.m_TextClassDistribution.getText()));
        model.setAdditional(new SpreadSheetColumnRange(this.m_TextAdditional.getText()));
        try {
            model.buildClassifier(null);
            this.m_Model = model;
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        File file = (File)this.m_PanelFile.getCurrent();
        if (file.isDirectory()) {
            return "File points to directory: " + file;
        }
        if (!file.exists()) {
            return "File does not exist: " + file;
        }
        String msg = this.createFakeModel();
        if (msg != null) {
            return msg;
        }
        if (this.m_Model == null) {
            return "Failed to load predictions: " + file;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        return new ResultItem(classifier, null);
    }

    @Override
    protected void doEvaluate(Classifier classifier, ResultItem item) throws Exception {
        classifier = (Classifier)ObjectCopyHelper.copyObject((Object)((Object)this.m_Model));
        String msg = this.canEvaluate(classifier);
        if (msg != null) {
            throw new IllegalArgumentException("Failed to process predictions!\n" + msg);
        }
        item.setTemplate(classifier);
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)((Object)this.m_Model)));
        runInfo.add("File", this.m_PanelFile.getCurrent());
        runInfo.add("Reader", (Object)this.m_PanelFile.getReader().toCommandLine());
        runInfo.add("Actual", (Object)this.m_TextActual.getText());
        runInfo.add("Predicted", (Object)this.m_TextPredicted.getText());
        runInfo.add("Weight", (Object)this.m_TextWeight.getText());
        runInfo.add("Class distribution", (Object)this.m_TextClassDistribution.getText());
        runInfo.add("Additional", (Object)this.m_TextAdditional.getText());
        WekaSpreadSheetToPredictions topred = new WekaSpreadSheetToPredictions();
        topred.setActual(new SpreadSheetColumnIndex(this.m_TextActual.getText()));
        topred.setPredicted(new SpreadSheetColumnIndex(this.m_TextPredicted.getText()));
        topred.setWeight(new SpreadSheetColumnIndex(this.m_TextWeight.getText()));
        topred.setClassDistribution(new SpreadSheetUnorderedColumnRange(this.m_TextClassDistribution.getText()));
        topred.setUseColumnNamesAsClassLabels(true);
        topred.input(new Token((Object)this.m_Model.getPredictions()));
        msg = topred.execute();
        if (msg != null) {
            throw new IllegalArgumentException("Failed to generated Evaluations object from predictions:\n" + msg);
        }
        Evaluation eval = (Evaluation)topred.output().getPayload();
        TIntArrayList original = new TIntArrayList();
        for (int i = 0; i < this.m_Model.getPredictions().getRowCount(); ++i) {
            original.add(i);
        }
        SpreadSheetView additional = null;
        if (!this.m_TextAdditional.getText().isEmpty()) {
            additional = new SpreadSheetView(this.m_Model.getPredictions(), null, this.m_Model.getAdditionalIndices());
        }
        item.update(eval, this.m_Model, runInfo, original.toArray(), (SpreadSheet)additional);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FILE, ((File)this.m_PanelFile.getCurrent()).getAbsolutePath());
            result.put(KEY_READER, this.m_PanelFile.getReader().toCommandLine());
            result.put(KEY_ACTUAL, this.m_TextActual.getText());
            result.put(KEY_PREDICTED, this.m_TextPredicted.getText());
            result.put(KEY_WEIGHT, this.m_TextWeight.getText());
            result.put(KEY_CLASSDISTRIBUTION, this.m_TextClassDistribution.getText());
            result.put(KEY_ADDITIONAL, this.m_TextAdditional.getText());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_FILE)) {
            this.m_PanelFile.setCurrent((File)new PlaceholderFile((String)data.get(KEY_FILE)));
        }
        if (data.containsKey(KEY_READER)) {
            try {
                this.m_PanelFile.setReader((SpreadSheetReader)OptionUtils.forCommandLine(OptionHandler.class, (String)((String)data.get(KEY_READER))));
            }
            catch (Exception e) {
                errors.add("Failed to parse spreadsheet reader command-line: " + data.get(KEY_READER), (Throwable)e);
            }
        }
        if (data.containsKey(KEY_ACTUAL)) {
            this.m_TextActual.setText((String)data.get(KEY_ACTUAL));
        }
        if (data.containsKey(KEY_PREDICTED)) {
            this.m_TextPredicted.setText((String)data.get(KEY_PREDICTED));
        }
        if (data.containsKey(KEY_WEIGHT)) {
            this.m_TextWeight.setText((String)data.get(KEY_WEIGHT));
        }
        if (data.containsKey(KEY_CLASSDISTRIBUTION)) {
            this.m_TextClassDistribution.setText((String)data.get(KEY_CLASSDISTRIBUTION));
        }
        if (data.containsKey(KEY_ADDITIONAL)) {
            this.m_TextAdditional.setText((String)data.get(KEY_ADDITIONAL));
        }
    }
}

