/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.SelectOptionPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.TestingHelper;
import weka.core.Capabilities;
import weka.core.Instances;

public class TrainTestSet
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = -4460266467650893551L;
    public static final String KEY_TRAIN = "train";
    public static final String KEY_TEST = "test";
    public static final String KEY_ADDITIONAL = "additional";
    public static final String KEY_DISCARDPREDICTIONS = "discardpredictions";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxTrain;
    protected BaseComboBox<String> m_ComboBoxTest;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected SelectOptionPanel m_SelectAdditionalAttributes;
    protected BaseCheckBox m_CheckBoxDiscardPredictions;

    public String globalInfo() {
        return "Trains the classifier on the selected training set and evaluates it against the selected test set.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = TrainTestSet.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxTrain = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxTrain.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Train", this.m_ComboBoxTrain);
        this.m_ComboBoxTest = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxTest.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Test", this.m_ComboBoxTest);
        this.m_SelectAdditionalAttributes = new SelectOptionPanel();
        this.m_SelectAdditionalAttributes.setCurrent((Object)new String[0]);
        this.m_SelectAdditionalAttributes.setMultiSelect(true);
        this.m_SelectAdditionalAttributes.setLenient(true);
        this.m_SelectAdditionalAttributes.setDialogTitle("Select additional attributes");
        this.m_SelectAdditionalAttributes.setToolTipText("Additional attributes to make available in plots");
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_SelectAdditionalAttributes);
        this.m_CheckBoxDiscardPredictions = new BaseCheckBox();
        this.m_CheckBoxDiscardPredictions.setSelected(props.getBoolean("Classify.DiscardPredictions", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxDiscardPredictions.setToolTipText("Save memory by discarding predictions?");
        this.m_CheckBoxDiscardPredictions.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Discard predictions", (Component)this.m_CheckBoxDiscardPredictions);
    }

    @Override
    public String getName() {
        return "Train/test set";
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxTrain)) {
            return "No train data available!";
        }
        if (!this.isValidDataIndex(this.m_ComboBoxTest)) {
            return "No test data available!";
        }
        Capabilities caps = classifier.getCapabilities();
        Instances train = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        try {
            if (!caps.test(train)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle train data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        caps = classifier.getCapabilities();
        caps.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        Instances test = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex()).getData();
        try {
            if (!caps.test(test)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle test data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        if (!train.equalHeaders(test)) {
            return train.equalHeadersMsg(test);
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(final Classifier classifier, ResultItem item) throws Exception {
        String msg = this.canEvaluate(classifier);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer trainCont = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxTrain.getSelectedIndex());
        final DataContainer testCont = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxTest.getSelectedIndex());
        Instances train = trainCont.getData();
        final Instances test = testCont.getData();
        boolean discard = this.m_CheckBoxDiscardPredictions.isSelected();
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)classifier));
        runInfo.add("Train ID", (Object)trainCont.getID());
        runInfo.add("Test ID", (Object)testCont.getID());
        runInfo.add("Relation (train)", (Object)train.relationName());
        runInfo.add("Relation (test)", (Object)test.relationName());
        runInfo.add("# Attributes", (Object)train.numAttributes());
        runInfo.add("# Instances (train)", (Object)train.numInstances());
        runInfo.add("# Instances (test)", (Object)test.numInstances());
        runInfo.add("Class attribute", (Object)train.classAttribute().name());
        runInfo.add("Discard predictions", (Object)discard);
        if (((String[])this.m_SelectAdditionalAttributes.getCurrent()).length > 0) {
            runInfo.add("Additional attributes: ", (Object)Utils.flatten((Object[])((Object[])this.m_SelectAdditionalAttributes.getCurrent()), (String)", "));
        }
        Classifier model = (Classifier)ObjectCopyHelper.copyObject((Object)classifier);
        ((ClassifyTab)this.getOwner()).logMessage("Using '" + trainCont.getID() + "/" + train.relationName() + "' to train " + OptionUtils.getCommandLine((Object)classifier));
        model.buildClassifier(train);
        this.addObjectSize(runInfo, "Model size", model);
        ((ClassifyTab)this.getOwner()).logMessage("Using '" + testCont.getID() + "/" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
        Evaluation eval = new Evaluation(train);
        eval.setDiscardPredictions(discard);
        TestingHelper.evaluateModel(model, test, eval, this.getTestingUpdateInterval(), new TestingHelper.TestingUpdateListener(){

            @Override
            public void testingUpdateRequested(Instances data, int numTested, int numTotal) {
                ((ClassifyTab)TrainTestSet.this.getOwner()).logMessage("Used " + numTested + "/" + numTotal + " of '" + testCont.getID() + "/" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)classifier));
            }
        });
        item.update(eval, model, runInfo, null, this.transferAdditionalAttributes(this.m_SelectAdditionalAttributes, test));
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxTrain.getSelectedItem());
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxTrain.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTrain.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxTrain.setSelectedIndex(index);
            }
            index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxTest.getSelectedItem());
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxTest.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxTest.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxTest.setSelectedIndex(index);
            }
        }
        this.fillWithAttributeNames(this.m_SelectAdditionalAttributes, this.m_ComboBoxTest.getSelectedIndex());
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxTrain.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_TRAIN, this.m_ComboBoxTrain.getSelectedIndex());
            result.put(KEY_TEST, this.m_ComboBoxTest.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_ADDITIONAL, this.m_SelectAdditionalAttributes.getCurrent());
            result.put(KEY_DISCARDPREDICTIONS, this.m_CheckBoxDiscardPredictions.isSelected());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_TRAIN)) {
            this.m_ComboBoxTrain.setSelectedIndex(((Number)data.get(KEY_TRAIN)).intValue());
        }
        if (data.containsKey(KEY_TEST)) {
            this.m_ComboBoxTest.setSelectedIndex(((Number)data.get(KEY_TEST)).intValue());
        }
        if (data.containsKey(KEY_ADDITIONAL)) {
            this.m_SelectAdditionalAttributes.setCurrent((Object)this.listOrArray(data.get(KEY_ADDITIONAL)));
        }
        if (data.containsKey(KEY_DISCARDPREDICTIONS)) {
            this.m_CheckBoxDiscardPredictions.setSelected(((Boolean)data.get(KEY_DISCARDPREDICTIONS)).booleanValue());
        }
    }
}

