/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.GraphHelper;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.GraphMLExporter;
import weka.core.Drawable;
import weka.gui.visualize.plugins.JGraphTTreeVisualization;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeAttributeProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeIDProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleEdgeLabelProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexAttributeProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexIDProvider;
import weka.gui.visualize.plugins.jgrapht.SimpleVertexLabelProvider;

public class TreeGraphML
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Outputs the tree graph source as GraphML (https://en.wikipedia.org/wiki/GraphML).";
    }

    @Override
    public String getTitle() {
        return "Tree GraphML";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasModel() && item.getModel() instanceof Drawable && GraphHelper.isDottyTree((Drawable)item.getModel());
    }

    protected String toGraphml(String dotty, MessageCollection errors) {
        try {
            StringWriter writer = new StringWriter();
            DirectedPseudograph graph = JGraphTTreeVisualization.getSingleton().importDotty(dotty);
            GraphMLExporter exporter = new GraphMLExporter((ComponentNameProvider)new SimpleVertexIDProvider(), (ComponentNameProvider)new SimpleVertexLabelProvider(), (ComponentAttributeProvider)new SimpleVertexAttributeProvider(), (ComponentNameProvider)new SimpleEdgeIDProvider(), (ComponentNameProvider)new SimpleEdgeLabelProvider(), (ComponentAttributeProvider)new SimpleEdgeAttributeProvider());
            exporter.exportGraph((Graph)graph, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            errors.add("Failed to export dotty as GraphML:\n" + dotty, (Throwable)e);
            return null;
        }
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasModel()) {
            errors.add("No model available!");
            return null;
        }
        try {
            String dotty = ((Drawable)item.getModel()).graph();
            String graphml = this.toGraphml(dotty, errors);
            if (graphml == null) {
                return null;
            }
            BaseTextArea text = new BaseTextArea();
            text.setEditable(false);
            text.setTextFont(Fonts.getMonospacedFont());
            text.setText(graphml);
            text.setCaretPosition(0);
            return new TextualContentPanel((JTextComponent)text, true);
        }
        catch (Exception e) {
            errors.add("Failed to obtain graph source!", (Throwable)e);
            return null;
        }
    }
}

