/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab;

import adams.core.DateUtils;
import adams.core.Shortening;
import adams.data.spreadsheet.MetaData;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import java.io.Serializable;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Instances;

public class ResultItem
extends AbstractResultItem {
    private static final long serialVersionUID = -3409493446200539772L;
    protected ClusterEvaluation m_Evaluation;
    protected Clusterer m_Template;
    protected Clusterer m_Model;
    protected String m_SupplementaryName;
    protected Serializable m_SupplementaryData;
    protected MetaData m_RunInformation;

    public ResultItem(Clusterer template, Instances header) {
        super(header);
        if (template == null) {
            throw new IllegalArgumentException("Template classifier cannot be null!");
        }
        this.m_Template = template;
    }

    @Override
    protected String createName() {
        String result = DateUtils.getTimeFormatterMsecs().format(this.m_Timestamp) + " - " + this.m_Template.getClass().getSimpleName();
        if (this.hasHeader()) {
            result = result + " - " + Shortening.shortenEnd((String)this.m_Header.relationName(), (int)30);
        }
        return result;
    }

    public void update(ClusterEvaluation evaluation, Clusterer model, MetaData runInfo) {
        this.update(evaluation, null, null, model, runInfo);
    }

    public void update(String supplementaryName, Serializable supplementaryData, Clusterer model, MetaData runInfo) {
        this.update(null, supplementaryName, supplementaryData, model, runInfo);
    }

    public void update(ClusterEvaluation evaluation, String supplementaryName, Serializable supplementaryData, Clusterer model, MetaData runInfo) {
        this.m_Model = model;
        this.m_SupplementaryName = supplementaryName;
        this.m_SupplementaryData = supplementaryData;
        this.m_Evaluation = evaluation;
        this.m_RunInformation = runInfo;
    }

    public boolean hasEvaluation() {
        return this.m_Evaluation != null;
    }

    public ClusterEvaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public void setTemplate(Clusterer value) {
        this.m_Template = value;
    }

    public Clusterer getTemplate() {
        return this.m_Template;
    }

    public boolean hasModel() {
        return this.m_Model != null;
    }

    public Clusterer getModel() {
        return this.m_Model;
    }

    public boolean hasSupplementaryName() {
        return this.m_SupplementaryName != null;
    }

    public String getSupplementaryName() {
        return this.m_SupplementaryName;
    }

    public boolean hasSupplementaryData() {
        return this.m_SupplementaryData != null;
    }

    public Object getSupplementaryData() {
        return this.m_SupplementaryData;
    }

    public boolean hasRunInformation() {
        return this.m_RunInformation != null;
    }

    public MetaData getRunInformation() {
        return this.m_RunInformation;
    }

    @Override
    public String toString() {
        String result = this.getName();
        result = result + ", evaluation=" + this.hasEvaluation() + ", template=" + this.getTemplate().getClass().getName() + ", model=" + this.hasModel() + ", supplementary=" + (this.hasSupplementaryName() && this.hasSupplementaryData()) + ", runInfo=" + this.hasRunInformation() + ", header=" + this.hasHeader();
        return result;
    }
}

