/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.Instances;

public class TrainTestSplit
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = -4460266467650893551L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_PERCENTAGE = "percentage";
    public static final String KEY_SEED = "seed";
    public static final String KEY_PRESERVEORDER = "preserveorder";
    public static final String KEY_USEVIEWS = "useviews";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected NumberTextField m_TextPercentage;
    protected BaseCheckBox m_CheckBoxPreserveOrder;
    protected NumberTextField m_TextSeed;
    protected BaseCheckBox m_CheckBoxUseViews;

    public String globalInfo() {
        return "Generates train/test sets from the selected dataset using the specified split percentage and builds/evaluates the clusterer accordingly.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_TextPercentage = new NumberTextField(NumberTextField.Type.DOUBLE, "" + props.getDouble("Classify.TrainPercentage", Double.valueOf(66.0)));
        this.m_TextPercentage.setToolTipText("Percentage for train set (0 < x < 100)");
        this.m_TextPercentage.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Percentage", (Component)this.m_TextPercentage);
        this.m_CheckBoxPreserveOrder = new BaseCheckBox();
        this.m_CheckBoxPreserveOrder.setSelected(props.getBoolean("Classify.PreserveOrder", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxPreserveOrder.setToolTipText("No randomization is performed if checked");
        this.m_CheckBoxPreserveOrder.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Preserve order", (Component)this.m_CheckBoxPreserveOrder);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("Classify.Seed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TrainTestSplit.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
        this.m_CheckBoxUseViews = new BaseCheckBox();
        this.m_CheckBoxUseViews.setSelected(props.getBoolean("Classify.UseViews", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxUseViews.setToolTipText("Save memory by using views instead of creating copies of datasets?");
        this.m_CheckBoxUseViews.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Use views", (Component)this.m_CheckBoxUseViews);
    }

    @Override
    public String getName() {
        return "Train/test split";
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        if (!Utils.isDouble((String)this.m_TextPercentage.getText())) {
            return "Percentage is not a number!";
        }
        double perc = Utils.toDouble((String)this.m_TextPercentage.getText());
        if (perc <= 0.0 || perc >= 100.0) {
            return "Percentage must satisfy 0 < x < 100!";
        }
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = clusterer.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        String msg = this.canEvaluate(clusterer);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer dataCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        double perc = this.m_TextPercentage.getValue().doubleValue() / 100.0;
        int seed = this.m_TextSeed.getValue().intValue();
        boolean views = this.m_CheckBoxUseViews.isSelected();
        DefaultRandomSplitGenerator generator = this.m_CheckBoxPreserveOrder.isSelected() ? new DefaultRandomSplitGenerator(data, perc) : new DefaultRandomSplitGenerator(data, seed, perc);
        generator.setUseViews(views);
        WekaTrainTestSetContainer cont = generator.next();
        Instances train = (Instances)cont.getValue("Train");
        Instances test = (Instances)cont.getValue("Test");
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Seed", (Object)seed);
        runInfo.add("Split percentage", (Object)perc);
        runInfo.add("Order preserved", (Object)this.m_CheckBoxPreserveOrder.isSelected());
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances (train)", (Object)train.numInstances());
        runInfo.add("# Instances (test)", (Object)test.numInstances());
        runInfo.add("Use views", (Object)views);
        Clusterer model = (Clusterer)ObjectCopyHelper.copyObject((Object)clusterer);
        ((ClusterTab)this.getOwner()).logMessage("Using " + this.m_TextPercentage.getText() + "% of '" + train.relationName() + "' to train " + OptionUtils.getCommandLine((Object)clusterer));
        model.buildClusterer(train);
        this.addObjectSize(runInfo, "Model size", model);
        ((ClusterTab)this.getOwner()).logMessage("Using remainder from '" + test.relationName() + "' to evaluate " + OptionUtils.getCommandLine((Object)clusterer));
        ClusterEvaluation eval = new ClusterEvaluation();
        eval.setClusterer(model);
        eval.evaluateClusterer(test);
        item.update(eval, model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_PERCENTAGE, this.m_TextPercentage.getValue().doubleValue());
            result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
            result.put(KEY_PRESERVEORDER, this.m_CheckBoxPreserveOrder.isSelected());
            result.put(KEY_USEVIEWS, this.m_CheckBoxUseViews.isSelected());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_PERCENTAGE)) {
            this.m_TextPercentage.setValue((Number)((Number)data.get(KEY_PERCENTAGE)).doubleValue());
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Number)data.get(KEY_SEED)).intValue());
        }
        if (data.containsKey(KEY_PRESERVEORDER)) {
            this.m_CheckBoxPreserveOrder.setSelected(((Boolean)data.get(KEY_PRESERVEORDER)).booleanValue());
        }
        if (data.containsKey(KEY_USEVIEWS)) {
            this.m_CheckBoxUseViews.setSelected(((Boolean)data.get(KEY_USEVIEWS)).booleanValue());
        }
    }
}

