/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction;

import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeRange;
import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.StringToDate;

public class ConvertToDate
extends AbstractSelectedAttributesAction {
    private static final long serialVersionUID = -217537095007987947L;

    public ConvertToDate() {
        this.setName("Convert to date");
        this.setIcon("to_date.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        if (this.getSelectedRows().length != 1) {
            return;
        }
        int index = this.getSelectedRows()[0];
        DataContainer cont = this.getData().get(index);
        int[] indices = this.getOwner().getAttributeSelectionPanel().getSelectedAttributes();
        if (indices.length == 0) {
            return;
        }
        StringBuilder indicesStr = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                indicesStr.append(",");
            }
            if (!cont.getData().attribute(indices[i]).isString()) {
                this.logError("Attribute at #" + (indices[i] + 1) + " is not of type string!", this.getName());
                return;
            }
            indicesStr.append("#" + (indices[i] + 1));
        }
        String format = GUIHelper.showInputDialog((Component)this.getOwner().getParent(), (String)"Please enter parse format:", (String)"yyyy-MM-dd HH:mm:ss");
        if (format == null) {
            return;
        }
        Runnable run = () -> {
            this.showStatus("Converting selected attributes to date: " + indicesStr);
            boolean keep = this.getOwner().getCheckBoxKeepName().isSelected();
            String oldName = cont.getData().relationName();
            StringToDate stringtodate = new StringToDate();
            stringtodate.setRange(new WekaAttributeRange(indicesStr.toString()));
            stringtodate.setFormat(format);
            this.logMessage("Filter: " + OptionUtils.getCommandLine((Object)((Object)stringtodate)));
            try {
                stringtodate.setInputFormat(cont.getData());
                Instances filtered = Filter.useFilter((Instances)cont.getData(), (Filter)stringtodate);
                if (keep) {
                    filtered.setRelationName(oldName);
                }
                cont.setData(filtered);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, this.getSelectedRows()[0]));
                SwingUtilities.invokeLater(() -> {
                    if (this.getOwner().getAttributeSelectionPanel().getTable().getRowCount() > 0) {
                        this.getOwner().getAttributeSelectionPanel().getTable().setSelectedRow(0);
                    }
                });
                this.showStatus("Finished converting selected attributes to date...");
            }
            catch (Throwable ex) {
                this.logError("Failed to convert selected attributes to date!", ex, this.getName());
            }
            this.m_Owner.executionFinished();
            this.showStatus("");
        };
        this.m_Owner.submitJob(run);
    }

    @Override
    public void update() {
        this.setEnabled(this.getOwner() != null && !this.isBusy() && this.getSelectedRows().length == 1 && this.getOwner().getAttributeSelectionPanel().getSelectedAttributes().length > 0 && this.m_Owner.canStartExecution());
    }
}

