/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.analysis;

import adams.core.io.FileUtils;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.tools.wekamultiexperimenter.analysis.AbstractResultsPanel;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import weka.experiment.ResultMatrixAdamsCSV;

public class TableResultsPanel
extends AbstractResultsPanel {
    private static final long serialVersionUID = 3608852939358175057L;
    protected BaseSplitPane m_SplitPane;
    protected SpreadSheetTable m_TableResults;
    protected BaseTextAreaWithButtons m_TextAreaKey;
    protected BaseButton m_ButtonCopy;
    protected BaseButton m_ButtonSave;
    protected BaseFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        ExtensionFileFilter filter = ExtensionFileFilter.getTextFileFilter();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooser.setFileFilter((FileFilter)filter);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setUISettingsParameters(((Object)((Object)this)).getClass(), "ResultsDivider");
        this.add((Component)this.m_SplitPane, "Center");
        this.m_TableResults = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_TableResults.setShowSimpleCellPopupMenu(true);
        this.m_TableResults.setShowSimpleHeaderPopupMenu(true);
        this.m_SplitPane.setTopComponent((Component)new BaseScrollPane((Component)this.m_TableResults));
        this.m_TextAreaKey = new BaseTextAreaWithButtons();
        this.m_TextAreaKey.setTextFont(Fonts.getMonospacedFont());
        this.m_SplitPane.setBottomComponent((Component)this.m_TextAreaKey);
        this.m_ButtonCopy = new BaseButton("Copy", (Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.addActionListener(e -> {
            if (this.m_TextAreaKey.getSelectedText() != null) {
                ClipboardHelper.copyToClipboard((String)this.m_TextAreaKey.getSelectedText());
            } else {
                ClipboardHelper.copyToClipboard((String)this.m_TextAreaKey.getText());
            }
        });
        this.m_TextAreaKey.addToButtonsPanel((Component)this.m_ButtonCopy);
        this.m_ButtonSave = new BaseButton("Save...", (Icon)GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonSave.addActionListener(e -> {
            int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            if (!FileUtils.writeToFile((String)this.m_FileChooser.getSelectedFile().getAbsolutePath(), (Object)this.m_TextAreaKey.getText(), (boolean)false)) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save output to:\n" + this.m_FileChooser.getSelectedFile()));
            }
        });
        this.m_TextAreaKey.addToButtonsPanel((Component)this.m_ButtonSave);
    }

    @Override
    public String getResultsName() {
        return "Table";
    }

    @Override
    protected void doDisplay() {
        int i;
        ResultMatrixAdamsCSV matrix = new ResultMatrixAdamsCSV(this.m_Matrix);
        matrix.setPrintColNames(false);
        String[][] array = matrix.toArray();
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        HeaderRow row = sheet.getHeaderRow();
        for (i = 0; i < array[0].length; ++i) {
            row.addCell("" + i).setContentAsString(array[0][i]);
        }
        for (int n = 1; n < array.length; ++n) {
            row = sheet.addRow();
            for (i = 0; i < array[n].length; ++i) {
                row.addCell("" + i).setContent(array[n][i]);
            }
        }
        this.m_TableResults.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)sheet));
        this.m_TableResults.setOptimalColumnWidthBounded(250);
        this.m_TextAreaKey.setText(this.m_Matrix.toStringKey());
        this.m_TextAreaKey.setCaretPosition(0);
    }

    @Override
    public TableResultsPanel getClone() {
        return new TableResultsPanel();
    }
}

